/*
 *   kwrl - a little VRML 2.0 viewer
 *   Copyright (C) 1998,99  Mark R. Stevens
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */


#ifndef CYLINDERSENSOR
#define CYLINDERSENSOR

// label
#define CylinderSensorLabel "CylinderSensor"

// classes
#include <SFNode.h>
#include <SFFloat.h>
#include <SFRotation.h>
#include <SFBool.h>
#include <SFVec3f.h>
#include <SFString.h>

// class definition
class CylinderSensor : public SFNode {

 public:

  // constructor
  CylinderSensor() : SFNode(CylinderSensorLabel) {
    minAngle             =  0.0;
    maxAngle             = -1.0;
    diskAngle            =  0.262;
    offset               =  0.0;
    autoOffset           =  true;
    enabled              =  true;
    isActive             =  false;
  }
    
  // destructor
  ~CylinderSensor() {
  }

  // parse
  void parse   (char         *, istream      &);

  // events
  void eventIn (SFString     &, SFNode       *);
  void eventOut(SFString     &, SFNode       *);

  // operators
  CylinderSensor &operator = (CylinderSensor &C2) {
    minAngle               = C2.minAngle;
    maxAngle               = C2.maxAngle;
    enabled                = C2.enabled;
    offset                 = C2.offset;
    autoOffset             = C2.autoOffset;
    isActive               = C2.isActive;
    trackPoint_changed     = C2.trackPoint_changed;
    rotation_changed       = C2.rotation_changed;
    isValid()              = C2.isValid();
    return(*this);
  }

  // USE-DEF
  SFNode *findDEF(SFString &UnsatUSE) {
    if (UnsatUSE == DEF) return(this);
    return((SFNode *) 0);
  }
  SFString *use() {
    return(&USE);
  }

 protected:

 private:

  // data
  SFFloat    minAngle;
  SFFloat    maxAngle;
  SFBool     enabled;
  SFFloat    diskAngle;
  SFFloat    offset;
  SFBool     autoOffset;

  // event data
  SFBool     isActive;
  SFVec3f    trackPoint_changed;
  SFRotation rotation_changed;

  // USE-DEF
  SFString   DEF;
  SFString   USE;

};

#endif // CylinderSensor
