/*
 *   kwrl - a little VRML 2.0 editor
 *   Copyright (C) 1998,99  Mark R. Stevens
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

/* local headers */
#include <SFToken.h>
#include <SFString.h>
#include <SFEvent.h>
#include <VisibilitySensor.h>
#include <Children.h>

/*************************************************************************/
void VisibilitySensor::eventOut(SFString &, SFNode *)
{

#ifdef DEBUG_EVENTS
  cout << "\nEntered VisibilitySensor::eventsOut(" << DEF << ")\n";
#endif 

}
/*************************************************************************/

/*************************************************************************/
void VisibilitySensor::eventIn(SFString &eventType, SFNode *eventData)
{

#ifdef DEBUG_EVENTS
  cout << "\nEntered VisibilitySensor::eventsIn (" << DEF << ")\n";
#endif 

  /* based on the input event choose an appropriate action */
  if ((eventType == "enabled") || (eventType == "set_enabled")) {
    SFBool *n = (SFBool *) eventData;
    enabled = *n;

  } else if ((eventType == "center") || (eventType == "set_center")) {
    SFVec3f *n = (SFVec3f *) eventData;
    center = *n;

  } else if ((eventType == "size") || (eventType == "set_size")) {
    SFVec3f *n = (SFVec3f *) eventData;
    size = *n;

  } 
}
/*************************************************************************/

/*************************************************************************/
void VisibilitySensor::parse(char *header, istream &InFile)
{

  /* we are valid */
  isValid() = true;

  /* a token in the file */
  SFToken Token;

  /* the required labels */
  bool TokenFound  = false;
  bool BeginBracketFound   = false;

  /* commence to search for the matching bracket */
  while (! InFile.eof()) {
    
    /* Remember where the token started from */
    Token.GetToken(InFile);

#ifdef DEBUG_PARSE
    cout << "\tVisibilitySensor: (" << Token() << ")\n";
#endif

    /* based on what token was found, continue parsing */
    if (Token == "DEF") {
      Token.GetToken(InFile);
      DEF = Token();

    } else if (Token == "USE") {
      Token.GetToken(InFile);
      USE = Token();
      unsatisfiedUSE() = true;
      return;

    } else if (Token == "enabled") {
      enabled.parse(header, InFile);

    } else if (Token == "center") {
      center.parse(header, InFile);

    } else if (Token == "size") {
      size.parse(header, InFile);

    } else if (Token == "VisibilitySensor") {
      TokenFound = true;

    } else if (Token == "{") {
      BeginBracketFound = true;

    } else if (Token == "}") {
      break;
      
    } else {
      parseWarning(Token());

    }
  }

  /* if we did not find the material token we are in trouble */
  if (TokenFound == false) {
    cerr << "\nError:\n";
    cerr << "\tOccurred in (" << nodeType() << "::parse())\n";
    cerr << "\tDid not find expected identifier token.\n";
    exit(0);
  }
  if (BeginBracketFound == false) {
    cerr << "\nError:\n";
    cerr << "\tOccurred in (" << nodeType() << "::parse())\n";
    cerr << "\tDid not find expected \"{\" token.\n";
    exit(0);
  }
}
/*************************************************************************/

