/*
 *   kwrl - a little VRML 2.0 viewer
 *   Copyright (C) 1998,99  Mark R. Stevens
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

/* local headers */
#include <SFVec3f.h>

/*************************************************************************/
void SFVec3f::parse(char *header, istream &InFile)
{
  /* we are valid */
  isValid() = true;

  /* we need to continue until three numbers are read */
  for (int i = 0; ((i < 3) && (! InFile.eof())); i++) {

    data[i].parse(header, InFile);

#ifdef DEBUG_PARSE_LOWEST
    cout << "\tSFVec3f: (" << data[i] << ")\n";
#endif

  }
}
/*************************************************************************/
