/*
 *   kwrl - a little VRML 2.0 editor
 *   Copyright (C) 1998,99  Mark R. Stevens
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

/* local headers */
#include <SFNode.h>
#include <SFToken.h>
#include <stdio.h>
#include <ctype.h>

/*************************************************************************/
static char isdelimit(char c) 
{

  /* delimiting tokens in vrml can be one of four types */
  return((c == '}') || (c == '{') || (c == '[') || (c == ']') || (c == ',') || (c == '"'));

}
/*************************************************************************/

/*************************************************************************/
static char iscomment(char c) 
{

  /* delimiting tokens in vrml can be one of four types */
  return(c == '#');

}
/*************************************************************************/

/*************************************************************************/
static char isint(char c) 
{

  /* has to be a digit or a + or - sign */
  return((isdigit(c)) || (c == '-') || (c == '+'));

}
/*************************************************************************/

/*************************************************************************/
static char isfloat(char c) 
{

  /* has to be a digit or a + or - sign */
  return((isint(c)) || (c == '.') || (c == 'e'));

}
/*************************************************************************/

/*************************************************************************/
bool SFToken::isSFInt32()
{

  /* empty strings are unknowns */
  if (strlen(data) == 0) return(false);

  /* check the string for valid decimal digits */
  for (unsigned int i = 0; i < strlen(data); i++) {
    if (isint(data[i]) == false) return(false);
  }

  /* everything checked out */
  return(true);

}
/*************************************************************************/

/*************************************************************************/
bool SFToken::isSFString()
{

  /* everything is always a string */
  if ((data[0] == '"') && (data[strlen(data) - 1] == '"')) {
    return(true);
  }

  /* the default */
  return(false);

}
/*************************************************************************/

/*************************************************************************/
bool SFToken::isSFFloat()
{

  /* empty strings are unknowns */
  if (strlen(data) == 0) return(false);

  /* check the string for valid decimal digits */
  for (unsigned int i = 0; i < strlen(data); i++) {
    if (isfloat(data[i]) == false) return(false);
  }

  /* everything checked out */
  return(true);

}
/*************************************************************************/

/*************************************************************************/
streampos SFToken::GetToken(istream &InFile)
{

  /* clear out the current token */
  strcpy(data, "\0");

  /* a token in the file */
  char c = '\0';

  /* read until a token character is found (skip comments) */
  streampos BeginningPoint; 
  do {
    if (iscomment(c) && (! InFile.eof())) {
      while ((c != '\n') && (! InFile.eof())) InFile >> c;
    }
    BeginningPoint = InFile.tellg();
    InFile >> c;

  } while ((iscomment(c) || isspace(c)) && (! InFile.eof()));

  /* if we reached the end of file we are done. */
  if (InFile.eof()) return(BeginningPoint);

  /* mark this point, as we will need to comeback to it after we have
  ** found the corresponding end of the string. */
  streampos p = InFile.tellg(); 

  /* we are at a non-blank character */
  int slot = 0;
  while (! InFile.eof()) {

    /* check the character for an end of token marker */
    if (isdelimit(c)) {
      if (slot == 0) {
	data[slot] = c;
	data[slot+1] = '\0';	
      } else {
	data[slot] = '\0';	
	InFile.seekg(p); 
      }
      break;
      
    } else if (iscomment(c)) {
      while (c != '\n') InFile >> c;
      data[slot] = '\0';	
      InFile.seekg(p); 
      break;

    } else if (isspace(c)) {
      data[slot] = '\0';	
      InFile.seekg(p); 
      break;

    } else {
      data[slot] = c;
      slot += 1;

    }

    /* mark this point, as we will need to comeback to it after we have
    ** found the corresponding end of the string. */
    p = InFile.tellg(); 

    /* get a character */
    InFile >> c;

  }
  
#ifdef DEBUG_PARSE_LOWEST
  cout << "\tSFToken: (" << data << ")\n";
#endif
  
  /* sometimes people go comma happy */
  if (*this == ",") return(GetToken(InFile));
  
  /* return the stream */
  return(BeginningPoint);

}
/*************************************************************************/
