/*
 *   kwrl - a little VRML 2.0 editor
 *   Copyright (C) 1998,99  Mark R. Stevens
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

/* local includes */
#include <SFNode.h>
#include <Children.h>
#include <TopLevel.h>
#include "VrmlParse.h"


/* c++ includes */
#include <iostream.h>
#include <fstream.h>
 
#define DEBUG_VRMLPARSE_NOT

/*************************************************************************/
SFNode *VrmlParse(SFRenderInfo &SFRI, const char *FileName)
{

#ifdef DEBUG_VRMLPARSE
  cout << "\nEntered VrmlParse\n";
#endif

  /* open the file */
  ifstream InFile(FileName);
  InFile.unsetf(ios::skipws);

  /* make sure the file was opened properly */
  if (InFile.bad()) {
    cerr << "\nError:\n";
    cerr << "\tOccurred in (CreateSceneGraph)";
    cerr << "\n\tCould not open file (" << FileName << ")\n";
    return((SFNode *) 0);
  }

  /* temp hack */
  TopLevel *top = new TopLevel;

#ifdef DEBUG_PARSE
  cout << "\nStarting parse of (" << FileName << ")\n";
#endif

  /* Start Reading tokens, keeping track of where they started */
  top->parse(SFRI, "./", InFile);

  /* return the created scene graph */
  return(top);

}
/*************************************************************************/







