/*
 *   kwrl - a little VRML 2.0 viewer
 *   Copyright (C) 1998,99  Mark R. Stevens
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#ifndef SCRIPT
#define SCRIPT

// label
#define ScriptLabel "Script"

// classes
#include <SFNode.h>
#include <SFBool.h>
#include <SFUrl.h>
#include <SFString.h>

// class definition
class Script : public SFNode {

 public:

  // constructor
  Script() : SFNode(ScriptLabel) {
    mustEvaluate = false;
    directOutput = false;
  }
  
  // destructor
  ~Script() {
  }

  // parse
  void parse   (char     *, istream  &);

  // events
  void eventIn (SFString &, SFNode   *);
  void eventOut(SFString &, SFNode   *);

  // operators
  Script &operator = (Script &S2) {
    url            = S2.url;
    mustEvaluate   = S2.mustEvaluate;
    directOutput   = S2.directOutput;
    isValid()      = S2.isValid();
    return(*this);
  }

  // USE-DEF
  SFNode *findDEF(SFString &UnsatUSE) {
    if (UnsatUSE == DEF) return(this);
    return((SFNode *) 0);
  }
  SFString *use() {
    return(&USE);
  }

 protected:


 private:

  // data
  SFBool  mustEvaluate;
  SFBool  directOutput;
  SFUrl   url;

  // USE-DEF
  SFString   DEF;
  SFString   USE;

};

#endif // Script
