/*
 *   kwrl - a little VRML 2.0 viewer
 *   Copyright (C) 1998,99  Mark R. Stevens
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */


#ifndef POINTLIGHT
#define POINTLIGHT

// label
#define PointLightLabel "PointLight"

// classes
#include <SFNode.h>
#include <SFBool.h>
#include <SFFloat.h>
#include <SFInt32.h>
#include <SFVec3f.h>
#include <SFColor.h>
#include <SFString.h>

// class definition
class PointLight : public SFNode {

 public:

  // constructor
  PointLight() : SFNode(PointLightLabel) {
    on               =   true;
    intensity        =   1.0;
    ambientIntensity =   0.0;
    color[0]         =   1.0;
    color[1]         =   1.0;
    color[2]         =   1.0;
    location[0]      =   0.0;
    location[1]      =   0.0;
    location[2]      =   0.0;
    radius           = 100.0;
    attenuation[0]   =   1.0;
    attenuation[1]   =   0.0;
    attenuation[2]   =   0.0;
  }

  // destructor
  ~PointLight() {
  }
  
  // parse
  void parse   (char         *, istream      &);

  // prepare
  void prepare (SFVec3f      &, SFVec3f      &);

  // render
  void render  (SFRenderInfo &);

  // events
  void eventIn (SFString     &, SFNode       *);

  // operators
  PointLight &operator = (PointLight &P2) {
    location           = P2.location;
    radius             = P2.radius;
    attenuation        = P2.attenuation;
    on                 = P2.on;
    intensity          = P2.intensity;
    ambientIntensity   = P2.ambientIntensity;
    color              = P2.color;
    isValid()          = P2.isValid();
    return(*this);
  }

  // USE-DEF
  SFNode *findDEF(SFString &UnsatUSE) {
    if (UnsatUSE == DEF) return(this);
    return((SFNode *) 0);
  }
  SFString *use() {
    return(&USE);
  }

 protected:

 private:

  // data
  SFVec3f   location;
  SFFloat   radius;
  SFVec3f   attenuation;
  SFBool    on;
  SFFloat   intensity;
  SFFloat   ambientIntensity;
  SFColor   color;

  // USE-DEF
  SFString DEF;
  SFString USE;
   
};

#endif // PointLight


