/*
 *   kwrl - a little VRML 2.0 viewer
 *   Copyright (C) 1998,99  Mark R. Stevens
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */


#ifndef PLANESENSOR
#define PLANESENSOR

// label
#define PlaneSensorLabel "PlaneSensor"

// classes
#include <SFNode.h>
#include <SFVec2f.h>
#include <SFVec3f.h>
#include <SFBool.h>

// class definition
class PlaneSensor : public SFNode {

 public:

  // constructor
  PlaneSensor() : SFNode(PlaneSensorLabel) {
    minPosition[0]         =  0.0;
    minPosition[1]         =  0.0;
    maxPosition[0]         = -1.0;
    maxPosition[1]         = -1.0;
    enabled                =  true;
    offset[0]              =  0.0;
    offset[1]              =  0.0;
    offset[2]              =  0.0;
    autoOffset             =  true;
    isActive               =  false;
  }
    
  // destructor
  ~PlaneSensor() {
  }

  // parse
  void parse   (char *, istream  &);

  // events
  void eventIn (SFString &, SFNode *);
  void eventOut(SFString &, SFNode *);

  // operators
  PlaneSensor &operator = (PlaneSensor &P2) {
    minPosition           = P2.minPosition;
    maxPosition           = P2.maxPosition;
    enabled               = P2.enabled;
    offset                = P2.offset;
    autoOffset            = P2.autoOffset;
    isActive              = P2.isActive;
    trackPoint_changed    = P2.trackPoint_changed;
    translation_changed   = P2.translation_changed;
    isValid()             = P2.isValid();
    return(*this);
  }

  // USE-DEF
  SFNode *findDEF(SFString &UnsatUSE) {
    if (UnsatUSE == DEF) return(this);
    return((SFNode *) 0);
  }
  SFString *use() {
    return(&USE);
  }

 protected:

 private:

  // data
  SFVec2f    minPosition;
  SFVec2f    maxPosition;
  SFBool     enabled;
  SFVec3f    offset;
  SFBool     autoOffset;

  // event data
  SFBool     isActive;
  SFVec3f    trackPoint_changed;
  SFVec3f    translation_changed;

  // USE-DEF
  SFString   DEF;
  SFString   USE;

};

#endif // PlaneSensor
