/*
 *   kwrl - a little VRML 2.0 viewer
 *   Copyright (C) 1998,99  Mark R. Stevens
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */


#ifndef ANCHOR
#define ANCHOR

// label
#define AnchorLabel "Anchor"

// classes
#include <SFNode.h>
#include <SFVec3f.h>
#include <Children.h>
#include <MFString.h>
#include <SFUrl.h>

// class definition
class Anchor : public SFNode {

 public:

  // constructor
  Anchor() : SFNode(AnchorLabel) {
    bboxCenter[0] =  0.0;
    bboxCenter[1] =  0.0;
    bboxCenter[2] =  0.0;
    bboxSize[0]   = -1.0;
    bboxSize[1]   = -1.0;
    bboxSize[2]   = -1.0;
  }
    
  // destructor
  ~Anchor() {
  }

  // parse
  void parse   (char         *, istream      &);

  // prepare
  void prepare (SFVec3f      &, SFVec3f      &);

  // render 
  void render  (SFRenderInfo &);

  // events
  void eventIn (SFString     &, SFNode       *);

  // operators
  Anchor &operator = (Anchor &A2) {
    description  = A2.description;
    parameter    = A2.parameter;
    url          = A2.url;
    bboxCenter   = A2.bboxCenter;
    bboxSize     = A2.bboxSize;
    children     = A2.children;
    isValid()    = A2.isValid();
    return(*this);
  }

  // Queue
  void push(Children &stack, SFString &stackType) {
    if (stackType == nodeType()) stack.add(this);
    else children.push(stack, stackType);
  }

  // USE-DEF
  SFNode *findDEF(SFString &UnsatUSE) {
    if (UnsatUSE == DEF) return(this);
    return(children.findDEF(UnsatUSE));
  }
  SFNode *findUSE() {
    if (unsatisfiedUSE()) return(this);
    return(children.findUSE());
  }
  SFString *use() {
    return(&USE);
  }

 protected:

 private:

  // data
  SFString    description;
  MFString    parameter;
  SFUrl       url;
  SFVec3f     bboxCenter;
  SFVec3f     bboxSize;
  Children    children;

  // USE-DEF
  SFString    DEF;
  SFString    USE;

};

#endif // ANCHOR
