/* $Id: docking.cpp,v 1.1.1.1 1998/07/03 14:28:27 matt Exp $
   $Log: docking.cpp,v $
   Revision 1.1.1.1  1998/07/03 14:28:27  matt
   Imported sources


   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/


#include <stdio.h>
#include <stdlib.h>

#include <qpixmap.h>

#include <kapp.h>
#include <kwm.h>
#include <kiconloader.h>

#include "docking.h"
#include "krootpict.h"


extern KRootPict *proot;


DockWidget::DockWidget(const char *name)
  : QWidget(0, name, 0) {

  // popup menu for right mouse button
  popup_m = new QPopupMenu();
  popup_m->insertItem(i18n("Settings"),
				 proot, SLOT(settings()));
  popup_m->insertItem(i18n("Exit"),
				 proot, SLOT(quit()));

  // setup icon
  KIconLoader *loader = KApplication::getKApplication()->getIconLoader();
  pixmap = loader->loadIcon("logo.xpm");

  // prepare panel to accept this widget
  KWM::setDockWindow (this->winId());

  // that's all the space there is
  this->setFixedSize(24, 24);

  // finally dock the widget
  this->show();

}


DockWidget::~DockWidget() {
}


void DockWidget::paintEvent (QPaintEvent *e) {

  (void) e;

  bitBlt(this, 0, 0, &pixmap);

}



void DockWidget::mousePressEvent(QMouseEvent *e) {

  if ( e->button() == LeftButton )
    proot->timeclick();
  else if ( e->button() == RightButton ) {
    // open popup menu on right mouse button
    int x = e->x() + this->x();
    int y = e->y() + this->y();

    popup_m->popup(QPoint(x, y));
    popup_m->exec();
  }

}

