#include "screen.moc"
#include "screen.h"
#include <qpainter.h>
#include <qpixmap.h>
#include <kprocess.h>

Screen::Screen ( uint xsize, uint ysize, 
		 int arg1, int arg2, int arg3, int arg4, int arg5, 
		 QWidget* parent, const char* )
  : QWidget ( parent, "KRay Picture" )
{
  QString xs, ys, a1, a2, a3, a4, a5;

  resize(xsize, ysize);
  setMinimumSize( xsize, ysize );
  setMaximumSize( xsize, ysize );
  setCaption("Kray Picture");

  pixmap = new QPixmap(xsize, ysize);
  color = new QColor();

  proc = new KProcess;
  xs.setNum(xsize);
  ys.setNum(ysize);
  a1.setNum(arg1);
  a2.setNum(arg2);
  a3.setNum(arg3);
  a4.setNum(arg4);
  a5.setNum(arg5);
  

  proc->setExecutable("rayclient");
  *proc << (const char*)xs << (const char*)ys    
        << (const char*)a1 << (const char*)a2
	<< (const char*)a3 << (const char*)a4
	<< (const char*)a5;
  
  QObject::connect(proc,SIGNAL(receivedStdout(KProcess*, char*, int)),
		   this,SLOT(paintPixel(KProcess*, char*, int)));
  QObject::connect(proc,SIGNAL(processExited (KProcess*)),
		   this,SLOT(pictureFinished(KProcess*)));

  picString = new QString();
  proc->start(KProcess::NotifyOnExit, KProcess::Stdout);
}


Screen::~Screen()
{
  // Remove yourself from parent's list !
}

void Screen::pictureFinished(KProcess*)
{
  repaint(0,0,-1,-1,true);
  warning("ChildProcess ended.");
  delete proc;
}

void Screen::paintPixel(KProcess*, char* pixel, int strlength)
{ 
  QString subString;
  uint x,y,r,g,b;
  uint ymin;

  QString infoString( pixel , strlength + 1 );
  QString restString( picString->data() );
  restString.append( infoString.data() );
  delete picString;

  if ( restString.length() >= 15 ) {
    y = ymin = restString.mid(3,3).toUInt();
    while ( restString.length() >= 15 ) {
      infoString = restString.left(15);
      x = infoString.mid(0,3).toUInt();
      y = infoString.mid(3,3).toUInt();
      r = infoString.mid(6,3).toUInt();
      g = infoString.mid(9,3).toUInt();
      b = infoString.mid(12,3).toUInt();
      drawPixel(x,y,r,g,b);
      restString = restString.right(restString.length() - 15);
    }
    picString = new QString(restString.data());
    repaint(0,ymin,-1,y-ymin+1,FALSE);
  }
}


void Screen::drawPixel(int x, int y, int r, int g, int b)
{
  QPainter p;
  p.begin( pixmap );
  color->setRgb(r,g,b);
  p.setPen(*color);
  p.drawPoint(x,y);
  p.end();
}

void Screen::paintEvent( QPaintEvent* )
{
  QPainter p;
  p.begin( this );
  p.drawPixmap(0,0,*pixmap);
  p.end();
}
  






