// -*- C++ -*-
//--------------------------------------------------------------------
// KRay Version 0.1
//
// File: surfaces.h
//
// Classes: Surface, all subclasses of Surface
//
// Purpose: The Surface classes get ``attached'' to the objects
// and influence their look.  Each Surface has mainly two member
// functions, namely getColor and getNorm.  The first one returns
// the color of the surface at a given point, the latter one, the
// distraction of reflection (can be seen on the surface water)
//--------------------------------------------------------------------
#ifndef __surfaces_h
#define __surfaces_h
#include "engine.h"
#include "vector.h"

class Surface {
public:
  // Member Functions
  Surface();
  virtual Color getColor(Vector p);
  virtual Vector getNorm(Vector p, Vector n);
public:
  // Private Members
  Color Od;
  double Oe, N;
  bool Refl, Trans;
  Color SpecC, TransC;
public:
  // Static Members
  static LatTyp Lattice;
private:
  static ColorTable MarbleTab, HellTab;
  // Static Member functions
  static void generateHellTable();
  static void generateMarbleTable();
private:
  static bool hellTableGenerated;
  static bool marbleTableGenerated;
  static void generateColorTable(long SampleCnt, ColTabSampleT* Samples, 
				 Color *ColTab);
};

class SkySurface : public Surface {
public:
  SkySurface();
  virtual Color getColor(Vector p);
};

class HellSurface : public Surface {
public:
  HellSurface();
  virtual Color getColor(Vector p);
};

class Marble : public Surface {
public:
  Marble();
  virtual Color getColor(Vector p);
};

class Water : public Surface {
public:
  Water();
  virtual Vector getNorm(Vector p, Vector n);
};

class Glass : public Surface {
public:
  Glass();
};

class Mirror : public Surface {
public:
  Mirror();
};

class Brass : public Surface {
public:
  Brass();
};

class RedSurface : public Surface {
public:
  RedSurface();
};

class GreenSurface : public Surface {
public:
  GreenSurface();
};


#endif
