// fish.cpp

#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#define MAX(a,b)	(a < b ? b : a)
#define MIN(a,b)	(a > b ? b : a)
#define RANGE(a,b,c)	(MIN(c,MAX(a,b)))
#define SQR(a)		((a) * (a))
#define SQRT(a)		sqrt(a)

#define SIZE		20
#define TILES		2

float facette(float x,float y,float z)
{
	float r0;
	
	x = x - floor(x);
	y = y - floor(y);
	z = z - floor(z);
	
	r0 = SQRT(SQR(x - 0.5) + SQR(y - 0.5) + SQR(z - 0.5));
	
	if(r0 <= 0.5)
		return r0;
	
	return r0 / 0.86602540378;
}


void	main()
{
	int	x,z,i;
	char	cm[20] = "ffff .,+*x8Wffff";
	
	for(z = 0;z < SIZE * TILES;z++)
	{
		for(x = 0;x < SIZE * TILES;x++)
		{
			i = 4 + (int)(8 * facette((float)x / SIZE,0.5,(float)z / SIZE));
			printf("%c",cm[i]);
		}
		printf("\n");
	}
}
