/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** texturebasewidget.h
*/
#ifndef __TextureBaseDIALOG_H__
#define __TextureBaseDIALOG_H__


#include <qwidget.h>
#include <qdialog.h>
#include <qlineedit.h>
#include <qlabel.h>
#include <qpushbutton.h>
#include <qcheckbox.h>
#include "../../3d/textures/texturebase.h"
#include <misc.h>

class TextureBaseWidget : public QWidget
{
Q_OBJECT
protected:
        QLineEdit		*name;
	QLabel			*nlabel;
	QCheckBox		*active;
	textureBase		*tb;
        QSize			qs;
	QFrame			*emptyFrame;
	bool			tactive;
	
public:

	TextureBaseWidget(QWidget *p, textureBase *);
	~TextureBaseWidget();
	void getTextureBase();

	int width();
	virtual QSize sizeHint() const;

public slots:
	void changeActive();
	void nameChanged();

signals:
	void valueChanged();

protected:
	void	paintEvent(QPaintEvent*);


};

//--------------------------------------------------------

class TextureBaseDialog : public QDialog
{
Q_OBJECT
protected:

	QPushButton		*ok,*cancel;
	TextureBaseWidget		*pw;

public:

	TextureBaseDialog(QWidget *p, textureBase *);
	~TextureBaseDialog();

protected:
	void	paintEvent(QPaintEvent*);
public slots:
	void okayPressed();
	void cancelPressed();
};

#endif
