/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** pigmentdialog.h
*/
#ifndef __PigmentDialog_H__
#define __PigmentDialog_H__


#include <qwidget.h>
#include <qgroupbox.h>
#include <qpainter.h>
#include <qcolor.h>
#include <qcombobox.h>
#include <kcolorbtn.h>
#include <qdialog.h>
#include <qlineedit.h>
#include <qpopupmenu.h>

#include <color.h>
#include "../../3d/textures/pigment.h"
#include "../widgets/vectorwidget.h"
#include "../widgets/tabwidget.h"
#include <qcolor.h>
#include <qlabel.h>
#include <qframe.h>

#include "texturebasewidget.h"

#include "texturewidgetbase.h"


class PigmentWidget : public TextureWidgetBase
{
Q_OBJECT
protected:
	pigment  *pig;

	TabWidget		*tab;
	int 			tabw,tabh;

	QColor qc;
	KColorButton		*cbt1;
	
	//PatternModifierDialog 	*pmw;
	
	TextureBaseWidget	*tbasew;	
	

	QPushButton		*pattern;
	
	QColor			quickColor;
	QLabel			*label1,*label3;
	QSize			qs;
	
public:

	PigmentWidget(QWidget *p, pigment *);
	~PigmentWidget();

	void getValue();

	virtual QSize	sizeHint() const;

protected:
	void	paintEvent(QPaintEvent*);

};

//----------------------------------------------------


class PigmentDialog : public QDialog
{
Q_OBJECT
protected:

	QPushButton		*ok,*cancel;
	PigmentWidget		*pw;

public:

	PigmentDialog(QWidget *p, pigment *);
	~PigmentDialog();

protected:
	void	paintEvent(QPaintEvent*);

public slots:
	void okayPressed();
	void cancelPressed();
};

#endif
