/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** pigmentdialog.cpp
*/

#include "pigmentdialog.moc"
#include "pigmentdialog.h"

#include <kapp.h>

PigmentWidget::PigmentWidget(QWidget *parent,pigment *p) :
	TextureWidgetBase(parent,"PigmentWidget")
{



	pig=p;	
	
	tbasew=new TextureBaseWidget(this,pig );
	connect(tbasew,SIGNAL(valueChanged()),this,SIGNAL(valueChanged()) );

	quickColor.setRgb( (int)(pig->getQuickColor(NULL)->red()*255.0), (int)(pig->getQuickColor(NULL)->green()*255.0), (int)(pig->getQuickColor(NULL)->blue()*255.0) ); //,(int)(col->transparency()*255) );
	cbt1=new KColorButton(quickColor,this);

	label1=new QLabel(i18n("Quick Color"),this);

	connect(cbt1,SIGNAL(changed(const QColor &)),this,SIGNAL(valueChanged()) );

	paintEvent(NULL);
}



PigmentWidget::~PigmentWidget()
{
	if (cbt1) delete cbt1;
	if (label1) delete label1;
	if (tbasew) delete tbasew;
}

void PigmentWidget::getValue()
{
color *clo=new color(NULL);

	clo->setRed((double)(cbt1->color().red()/255.0));
	clo->setGreen((double)(cbt1->color().green()/255.0));
	clo->setBlue((double)(cbt1->color().blue()/255.0));

	pig->setQuickColor(clo);
	tbasew->getTextureBase();
}

QSize PigmentWidget::sizeHint() const
{
	return qs;
}

void PigmentWidget::paintEvent(QPaintEvent* qp)
{
int w=tbasew->sizeHint().width();
int h=tbasew->sizeHint().height();
int y=0,w1=0,h1=0;

	


	tbasew->setGeometry(10,10,w,h);
	y+=15+h;

	w1=label1->sizeHint().width();
	h1=label1->sizeHint().height();

	label1->setGeometry(10,y+h1/2,w1,h1);
	cbt1->setGeometry(10+w1+5,y,2*h1,2*h1);	

	y+=2*h1+5;
	w=MAX(10+w1+5+h1,w);


	qs.setWidth(w+5);
	qs.setHeight(y+5);
	if (qp) QWidget::paintEvent(qp);
}

//------------------------------------------------------------------------

PigmentDialog::PigmentDialog(QWidget *parent,pigment *p) :
	QDialog(parent,"PigmentDialog",true)
{
	setCaption(i18n("Pigment"));

	ok=new QPushButton(i18n("Ok"),this);
	cancel=new QPushButton(i18n("Cancel"),this);

	pw=new PigmentWidget(this,p);

	connect (ok,SIGNAL(pressed()),this,SLOT(okayPressed()) );
	connect (cancel,SIGNAL(pressed()),this,SLOT(cancelPressed()) );

	paintEvent(NULL);
}

PigmentDialog::~PigmentDialog()
{
	if (pw) delete pw;
	if (ok) delete ok;
	if (cancel) delete cancel;
}


void PigmentDialog::cancelPressed()
{
	QDialog::done(0);
}

void PigmentDialog::okayPressed()
{
	pw->getValue();
	QDialog::done(1);
}

void PigmentDialog::paintEvent(QPaintEvent* qp)
{
 	int w=pw->sizeHint().width();
	int h=pw->sizeHint().height();

	int w1=ok->sizeHint().width();
	int w2=cancel->sizeHint().width();
	int h1=ok->sizeHint().height();

	cancel->setGeometry(w-w2-5,h+5,w2,h1);
	ok->setGeometry(w-w2-w1-10,h+5,w1,h1);

	h+=h1+5;

	pw->setGeometry(0,0,w,h);
	setMinimumSize(w,h);
	setMaximumSize(w,h);
	if (qp) QDialog::paintEvent(qp);
}
