/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** interiordialog.cpp
*/
#include "interiordialog.h"
#include "interiordialog.moc"

#include "../widgets/sliderwidget.h"

#include <kapp.h>

InteriorWidget::InteriorWidget(QWidget *parent,interior *n) :
	TextureWidgetBase(parent,"InteriorWidget")
{
color *col;
	med=n;

	tab=new TabWidget(this,"",0);

	tbasew=new TextureBaseWidget(this,med );
	connect(tbasew,SIGNAL(valueChanged()),this,SIGNAL(valueChanged()) );

	page1=new QWidget();

	col=med->getAbsorption();
	qc.setRgb( (int)(col->red()*255.0), (int)(col->green()*255.0), (int)(col->blue()*255.0) ); //,(int)(col->transparency()*255) );
	absorption=new KColorButton(qc,page1);	
	alabel=new QLabel(i18n("Absorption"),page1);
	connect(absorption,SIGNAL(changed(const QColor &)),this,SIGNAL(valueChanged()) );

	col=med->getEmission();
	qc.setRgb( (int)(col->red()*255.0), (int)(col->green()*255.0), (int)(col->blue()*255.0) );
	emission=new KColorButton(qc,page1);	
	elabel=new QLabel(i18n("Emission"),page1);
	connect(emission,SIGNAL(changed(const QColor &)),this,SIGNAL(valueChanged()) );

       	col=med->getScatter();
	qc.setRgb( (int)(col->red()*255.0), (int)(col->green()*255.0), (int)(col->blue()*255.0) );
	scatterc=new KColorButton(qc,page1);	
	slabel=new QLabel(i18n("Scatter"),page1);
	connect(scatterc,SIGNAL(changed(const QColor &)),this,SIGNAL(valueChanged()) );

	scatterecc=new PercentWidget(page1,i18n("Excentricity:"),med->getScatterECC() );
	connect(scatterecc,SIGNAL(valueChanged()),this,SIGNAL(valueChanged()) );

	scatterecp=new PercentWidget(page1,i18n("Extinktion:"),med->getScatterEXT() );
	connect(scatterecp,SIGNAL(valueChanged()),this,SIGNAL(valueChanged()) );

	page2=new QWidget();
	
	samplemax=new SpinBox(page2,i18n("Sample Max.:"),med->getSampleMax());
	samplemax->DownTopValue(0,1000);
	connect(samplemax,SIGNAL(valueChanged()),this,SIGNAL(valueChanged()) );

	samplemin=new SpinBox(page2,i18n("Sample Min.:"),med->getSampleMin());
	samplemin->DownTopValue(0,1000);
	connect(samplemin,SIGNAL(valueChanged()),this,SIGNAL(valueChanged()) );

	ratio=new SpinBox(page2,i18n("Ratio:"),med->getRatio());
	ratio->DownTopValue(0,1000);
	connect(ratio,SIGNAL(valueChanged()),this,SIGNAL(valueChanged()) );

	confidence=new SpinBox(page2,i18n("Confidence:"),med->getConfidence());
	confidence->DownTopValue(0,1000);
	connect(confidence,SIGNAL(valueChanged()),this,SIGNAL(valueChanged()) );

	variance=new SpinBox(page2,i18n("Variance:"),med->getVariance());
	variance->DownTopValue(0,1000);
	connect(variance,SIGNAL(valueChanged()),this,SIGNAL(valueChanged()) );

	intervalls=new SliderWidget(page2,i18n("Intervalls"),med->getIntervals(),0,500);
	connect(intervalls,SIGNAL(valueChanged()),this,SIGNAL(valueChanged()) );

	tab->addWidget(page1,0,(char*)i18n("Colors"));
	tab->addWidget(page2,1,(char*)i18n("Parameters"));
	tab->select(1);

	paintEvent(NULL);
}

InteriorWidget::~InteriorWidget()
{
	if (tbasew) delete tbasew;
}


void InteriorWidget::getValue()
{
color *col1=new color(NULL),*col2=new color(NULL);
color *col3=new color(NULL);

	tbasew->getTextureBase();

	col1->setRed( (double)  (absorption->color().red()/255.0)   );
	col1->setGreen( (double)(absorption->color().green()/255.0) );
	col1->setBlue( (double) (absorption->color().blue()/255.0)  );
	col2->setRed( (double)  (emission->color().red()/255.0)   );
	col2->setGreen( (double)(emission->color().green()/255.0) );
	col2->setBlue( (double) (emission->color().blue()/255.0)  );
	col3->setRed( (double)  (scatterc->color().red()/255.0)   );
	col3->setGreen( (double)(scatterc->color().green()/255.0) );
	col3->setBlue( (double) (scatterc->color().blue()/255.0)  );

	med->setScatter(col3);
	med->setEmission(col2);
	med->setAbsorption(col1);	

	med->setSampleMax(samplemax->getValue() );
	med->setSampleMin(samplemin->getValue() );
	med->setRatio(ratio->getValue() );
	med->setConfidence(confidence->getValue() );	
	med->setVariance(variance->getValue() );
	med->setIntervals(intervalls->getValue() );

	med->setScatterECC(scatterecc->getValue());
	med->setScatterEXT(scatterecp->getValue());
}

QSize InteriorWidget::sizeHint() const
{
	return qs;
}

void InteriorWidget::paintEvent(QPaintEvent* qp)
{
int w=tbasew->sizeHint().width();
int h=tbasew->sizeHint().height();
int y=0,wt,ht;

	tbasew->setGeometry(10,10,w,h);
	y+=15+h;
	w+=10;


	//page1
	{

	int w1=alabel->sizeHint().width();
	int h1=alabel->sizeHint().height();
	absorption->setGeometry(10,10,h1*2,h1*2);
	alabel->setGeometry(h1*2+15,10+h1,w1,h1);	
	y=15+h1*2;
	w=MAX(w,h1*2+15+w1);

	w1=elabel->sizeHint().width();
	h1=elabel->sizeHint().height();
	emission->setGeometry(10,y,h1*2,h1*2);
	elabel->setGeometry(h1*2+15,y+h1,w1,h1);
	y+=h1*2+5;
	w=MAX(w,h1*2+15+w1);

	w1=slabel->sizeHint().width();
	h1=slabel->sizeHint().height();
	scatterc->setGeometry(10,y,h1*2,h1*2);	
	slabel->setGeometry(15+h1*2,y+h1,w1,h1);
	y+=h1*2+5;
	w=MAX(w,h1*2+15+w1);

	scatterecc->layout(scatterecc,scatterecp);

	w1=scatterecc->sizeHint().width();
	h1=scatterecc->sizeHint().height();
	scatterecc->setGeometry(10,y,w1,h1);
	y+=h1+5;
	w=MAX(w,10+w1);

	w1=scatterecp->sizeHint().width();
	h1=scatterecp->sizeHint().height();	
	scatterecp->setGeometry(10,y,w1,h1);
        y+=h1+5;
	w=MAX(w,10+w1);
	}
	//page2
	{
	int wm=0,y1=0;
	int w1=samplemax->sizeHint().width();
	int h1=samplemax->sizeHint().height();
	
	samplemax->layout(samplemax,samplemin,ratio,confidence,variance);

	samplemax->setGeometry(10,10,w1,h1);
	samplemin->setGeometry(10,10+h1+5,w1,h1);
	y1=20+2*h1;
	wm=10+w1;

	w1=intervalls->sizeHint().width();
	//h=intervalls->sizeHint().height();
	intervalls->setGeometry(10,y1,w1,h1);
	y1+=h1+5;
	wm=MAX(wm,10+w1);

	w1=ratio->sizeHint().width();
	h1=ratio->sizeHint().height();
	ratio->setGeometry(10,y1,w1,h1);
	y1+=h1+5;

	w1=confidence->sizeHint().width();
	h1=confidence->sizeHint().height();
	confidence->setGeometry(10,y1,w1,h1);
	y1+=h1+5;
	wm=MAX(wm,10+w1);

	w1=variance->sizeHint().width();
	h1=variance->sizeHint().height();
	variance->setGeometry(10,y1,w1,h1);	
        y1+=h1+5;
	wm=MAX(wm,10+w1);	
	w=MAX(w,wm);
	y=MAX(y1,y);	
        }

	tab->setSize(w,y);
	wt=tab->sizeHint().width();
	ht=tab->sizeHint().height();

	tab->setGeometry(10,tbasew->sizeHint().height()+10,wt,ht);

	qs.setWidth(MAX(wt,w)+15);
	qs.setHeight(ht+tbasew->sizeHint().height()+10);

	if (qp) QWidget::paintEvent(qp);
}


//----------------------------------------------------------

InteriorDialog::InteriorDialog(QWidget *parent,interior *n) :
	QDialog(parent,"InteriorDialog",true)
{
	ok=new QPushButton(i18n("Ok"),this);
	cancel=new QPushButton(i18n("Cancel"),this);

	pw=new InteriorWidget(this,n);

	connect (ok,SIGNAL(pressed()),this,SLOT(okayPressed()) );
	connect (cancel,SIGNAL(pressed()),this,SLOT(cancelPressed()) );

	paintEvent(NULL);
}


void InteriorDialog::okayPressed()
{  	
	pw->getValue();   //Widgetwerte in Pointer sichern
	QDialog::done(1);
}

void InteriorDialog::cancelPressed()
{
	QDialog::done(0);
}

InteriorDialog::~InteriorDialog()
{
	if (pw) delete pw;
	if (ok) delete ok;
	if (cancel) delete cancel;
}

void InteriorDialog::paintEvent(QPaintEvent* qp)
{
 	int w=pw->sizeHint().width();
	int h=pw->sizeHint().height();

	int w1=ok->sizeHint().width();
	int w2=cancel->sizeHint().width();
	int h1=ok->sizeHint().height();

	cancel->setGeometry(w-w2-5,h+5,w2,h1);
	ok->setGeometry(w-w2-w1-10,h+5,w1,h1);

	setMinimumSize(w,h);
	setMaximumSize(w,h);

	pw->setGeometry(0,0,w,h);

	if (qp) QDialog::paintEvent(qp);
}

