/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** bumpmapdialog.cpp
*/
#include "bumpmapdialog.h"
#include "bumpmapdialog.moc"

#include <qtooltip.h>

#include <kapp.h>

BumpMapWidget::BumpMapWidget(QWidget *parent,bumpMap *b) :
	TextureWidgetBase(parent,"Bumpmap")
{
	#ifdef DEBUG
	printf("Entering BumpMapWidget-Constructor\n");
	#endif
	
	bu=b;
	bmm=bu->getModifier();

	preview=new Image(this,true);
	if (bu->getBumpMapFilename()!=NULL) preview->load(bu->getBumpMapFilename());

	tbasew=new TextureBaseWidget(this,bu);
	connect(tbasew,SIGNAL(valueChanged()),this,SIGNAL(valueChanged()) );

	filewidget=new GetFileWidget(this,i18n("File:"),bu->getBumpMapFilename(),1);
	connect(filewidget,SIGNAL(changed()),this,SLOT(newImage()) );

	mapping=new QComboBox(this);
	mapping->insertItem(i18n("planar") );
	mapping->insertItem(i18n("spherical") );
	mapping->insertItem(i18n("(reserved#1)") );
	mapping->insertItem(i18n("(reserved#2)") );
	mapping->insertItem(i18n("donut/torus") );
	mapping->setCurrentItem(bmm->getMapType() );	
#if (USE_QTOOLTIP == 1)
	QToolTip::add(mapping,i18n("The mapping of the imagefile around your object") );
#endif
	connect(mapping,SIGNAL(highlighted(int)),this,SIGNAL(valueChanged()) );

	maplabel=new QLabel(this);
	maplabel->setText(i18n("Mapping:") );

	once=new QCheckBox(i18n("Once") ,this);
	connect(once,SIGNAL(pressed()),this,SIGNAL(valueChanged()) );	
#if (USE_QTOOLTIP == 1)
	QToolTip::add(once,i18n("Should the image only mapped once ?") );
#endif

	if (bmm->getOnce()==1) once->setChecked(true);
	else once->setChecked(false);

       	interpolate=new QComboBox(this);
	interpolate->insertItem(i18n("none") );
	interpolate->insertItem(i18n("bilinear") );
	interpolate->insertItem(i18n("normalized") );
	connect(interpolate,SIGNAL(highlighted(int)),this,SIGNAL(valueChanged()) );
#if (USE_QTOOLTIP == 1)
	QToolTip::add(interpolate,i18n("Interpolation of the image") );
#endif


	switch(bmm->getInterpolate()) {
		case 0:interpolate->setCurrentItem(0);
		break;
		case 2:interpolate->setCurrentItem(1);
		break;
		case 4:interpolate->setCurrentItem(2);
		break;
	}

   	interpolatelabel=new QLabel(i18n("Interpolation:"),this);

	bslabel=new QLabel(i18n("Depth:"),this);
	bumpsize=new SpinBox(this,"",bu->getBumpSize());
	connect(bumpsize,SIGNAL(changed()),this,SIGNAL(valueChanged()) );

	QToolTip::add(bumpsize,i18n("The \"height\" of the image (bumpmap)") );

	usecolor = new QCheckBox(i18n("Use Color"),this);
	if (bu->getBumpUseColor()==true) usecolor->setChecked(true);
	else usecolor->setChecked(false);
	connect(usecolor,SIGNAL(pressed()),this,SIGNAL(valueChanged()) );	
	QToolTip::add(usecolor,i18n("Use the Palette-Index or the color values to describe the height") );


	paintEvent(NULL);
	#ifdef DEBUG
	printf("Leaving BumpMapWidget-Constructor\n");
	#endif	
}

void BumpMapWidget::newImage()
{
QString name=filewidget->getFilename(),tmp;	
	preview->load(name);
	emit valueChanged();
	paintEvent(NULL);
}

BumpMapWidget::~BumpMapWidget()
{
	if (tbasew) delete tbasew;
}


void BumpMapWidget::getValue()
{
	bu->setBumpMapFilename( (const char *)filewidget->getFilename());
	bu->setBumpMapFiletype( (const char *)filewidget->getImageType());
	tbasew->getTextureBase();
	if (usecolor->isChecked()) bu->setBumpUseColor();
	else bu->setBumpUseIndex();
	bu->setBumpSize(bumpsize->getValue());	

	bmm->setMapType(mapping->currentItem());
	if (once->isChecked()) bmm->setOnce();
	else bmm->unSetOnce();
	switch(interpolate->currentItem() ) {
		case 0: bmm->setInterpolate(0);
		break;
		case 1:bmm->setInterpolate(2);
		break;
		case 2:bmm->setInterpolate(4);
		break;
	}
}

QSize BumpMapWidget::sizeHint() const
{
	return qs;
}

void BumpMapWidget::paintEvent(QPaintEvent* qp)
{
int w=tbasew->sizeHint().width();	
int h=tbasew->sizeHint().height();
int y=10,wmax=w+10,w1=0;

	tbasew->setGeometry(10,y,w,h);

        y+=h+15;

	w=preview->sizeHint().width();
	h=preview->sizeHint().height();

	preview->setGeometry(10,y,w,h);
	preview->update();

	y+=h+5;

	w=filewidget->sizeHint().width();	
	h=filewidget->sizeHint().height();
	filewidget->setGeometry(10,y,w,h);
	if (wmax<(10+w)) wmax=10+w;
	
	y+=h+5;
	w=bslabel->sizeHint().width();	
	h=bumpsize->sizeHint().height();

	bslabel->setGeometry(10,y,w,h);
	w1=bumpsize->sizeHint().width();	
	bumpsize->setGeometry(10+w+5,y,w1,h);
	if (wmax<(10+w+w1)) wmax=10+w+w1;	

	y+=h+5;
	w=usecolor->sizeHint().width();	
	h=usecolor->sizeHint().height();
	usecolor->setGeometry(10,y,w,h);	
	w1=once->sizeHint().width();		
	once->setGeometry(10+w+5,y,w1,h);	
	if (wmax<(10+w+w1+5)) wmax=10+w1+w+5;

	y+=h+5;
	w=maplabel->sizeHint().width();	
	h=mapping->sizeHint().height();
	maplabel->setGeometry(10,y,w,h);
	w1=mapping->sizeHint().width();	
	mapping->setGeometry(10+w+5,y,w1,h);
        if (wmax<(10+w+w1+5)) wmax=10+w+w1+5;
	
	y+=h+5;
	w=interpolatelabel->sizeHint().width();	
	h=interpolate->sizeHint().height();
	interpolatelabel->setGeometry(10,y,w,h);
	w1=interpolate->sizeHint().width();	
	interpolate->setGeometry(10+w+5,y,w1,h);	
	if (wmax<(10+w+w1+5)) wmax=10+w+w1+5;	

	y+=h+5;
	qs.setHeight(y);
	qs.setWidth(wmax);
	if (qp) QWidget::paintEvent(qp);
}
//------------------------------------------------------------------------

BumpMapDialog::BumpMapDialog(QWidget *parent,bumpMap *b) :
	QDialog(parent,"BumpMapDialog",true)
{
	setCaption(i18n("BumpMap") );

	ok=new QPushButton(i18n("Ok"),this);
	cancel=new QPushButton(i18n("Cancel"),this);

	pw=new BumpMapWidget(this,b);

	connect (ok,SIGNAL(clicked()),this,SLOT(okayPressed()) );
	connect (cancel,SIGNAL(clicked()),this,SLOT(cancelPressed()) );

	paintEvent(NULL);
}

BumpMapDialog::~BumpMapDialog()
{
	if (ok) delete ok;
	if (cancel) delete cancel;
	if (pw) delete pw;
}


void BumpMapDialog::cancelPressed()
{
	QDialog::done(0);
}

void BumpMapDialog::okayPressed()
{
	pw->getValue();
	QDialog::done(1);
}


void BumpMapDialog::paintEvent(QPaintEvent* qp)
{
	int w=pw->sizeHint().width();
	int h=pw->sizeHint().height();

	int w1=ok->sizeHint().width();
	int w2=cancel->sizeHint().width();
	int h1=ok->sizeHint().height();

	cancel->setGeometry(w-w2-5,h+5,w2,h1);
	ok->setGeometry(w-w2-w1-10,h+5,w1,h1);
	pw->setGeometry(0,0,w,h);

	setMinimumSize(w,h);
	setMaximumSize(w,h);

	QDialog::paintEvent(qp);
}
