/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*

*/

#include "blackholewarpwidget.moc"
#include "blackholewarpwidget.h"

#include <kapp.h>

blackHoleWarpWidget::blackHoleWarpWidget(QWidget *parent,blackHoleWarp *p) :
	TextureWidgetBase(parent,"blackHoleWarpWidget")
{
	wa=p;	
	
	tbasew=new TextureBaseWidget(this,wa );
	connect(tbasew,SIGNAL(valueChanged()),this,SIGNAL(valueChanged()) );

	location=new VectorWidget(this,i18n("Location"));
	location->setVector(wa->getLocation());
	connect(location,SIGNAL(changed()),this,SIGNAL(valueChanged()) );

	repeat=new VectorWidget(this,i18n("Repeat"));
	repeat->setVector(wa->getRepeat());
	connect(repeat,SIGNAL(changed()),this,SIGNAL(valueChanged()) );

	turbulence=new VectorWidget(this,i18n("Turbulence"));
	turbulence->setVector(wa->getTurbulence());
	connect(turbulence,SIGNAL(changed()),this,SIGNAL(valueChanged()) );

	radius=new SpinBox(this,i18n("Radius"),wa->getRadius() );
	connect(radius,SIGNAL(valueChanged()),this,SIGNAL(valueChanged()) );

	falloff=new SpinBox(this,i18n("Fall off"),wa->getFallOff() );
	connect(falloff,SIGNAL(valueChanged()),this,SIGNAL(valueChanged()) );

	strength=new SpinBox(this,i18n("Strength"),wa->getStrength() );
	connect(strength,SIGNAL(valueChanged()),this,SIGNAL(valueChanged()) );

	inverse=new QCheckBox(i18n("Inverse"),this);
	inverse->setChecked(wa->getInverse());
	connect(inverse,SIGNAL(clicked()),this,SIGNAL(valueChanged()) );

	paintEvent(NULL);
}



blackHoleWarpWidget::~blackHoleWarpWidget()
{
	if (tbasew) delete tbasew;
        if (location) delete location;
	if (repeat) delete repeat;
	if (turbulence) delete turbulence;
	if (radius) delete radius;
	if (falloff) delete falloff;
	if (strength) delete strength;
	if (inverse) delete inverse;
}

void blackHoleWarpWidget::getValue()
{
	tbasew->getTextureBase();
       	wa->setLocation(location->getVector() );
	wa->setRepeat(repeat->getVector() );
	wa->setTurbulence(turbulence->getVector() );
	wa->setRadius(radius->getValue() );
	wa->setFallOff(falloff->getValue() );
	wa->setStrength(strength->getValue() );
	wa->setInverse(inverse->isChecked() );
}

QSize blackHoleWarpWidget::sizeHint() const
{
	return qs;
}

void blackHoleWarpWidget::paintEvent(QPaintEvent* qp)
{
int w=tbasew->sizeHint().width();
int h=tbasew->sizeHint().height();
int y=0,w2=0,wm=0,h2=0;


	tbasew->setGeometry(10,10,w,h);
	y+=15+h;
	wm=w;

        w=location->sizeHint().width();
        h=location->sizeHint().height();
        w2=radius->sizeHint().width();	
        h2=radius->sizeHint().height();	
	location->setGeometry(10,y,w,h);
	radius->setGeometry(15+w,y,w2,h2);
	wm=MAX(wm,w+w2+15);
	y+=h+5;

        w=strength->sizeHint().width();	
        h=strength->sizeHint().height();	
        w2=falloff->sizeHint().width();	
	
	strength->setGeometry(10,y,w,h);
	falloff->setGeometry(15+w,y,w2,h);
        wm=MAX(wm,15+w+w2);
	y+=h+10;

        w=repeat->sizeHint().width();	
        w2=turbulence->sizeHint().width();	
        h=turbulence->sizeHint().height();	
	repeat->setGeometry(10,y,w,h);
	turbulence->setGeometry(15+w,y,w2,h);
        wm=MAX(wm,15+w+w2);

	y+=h+5;	
	
        w=inverse->sizeHint().width();	
        h=inverse->sizeHint().height();	
	inverse->setGeometry(10,y,w,h);

	y+=h+5;

	qs.setWidth(wm+5);
	qs.setHeight(y+5);
	if (qp) QWidget::paintEvent(qp);
}

//------------------------------------------------------------------------

blackHoleWarpDialog::blackHoleWarpDialog(QWidget *parent,blackHoleWarp *p) :
	QDialog(parent,"blackHoleWarpDialog",true)
{
	setCaption(i18n("blackHoleWarp"));

	ok=new QPushButton(i18n("Ok"),this);
	cancel=new QPushButton(i18n("Cancel"),this);

	pw=new blackHoleWarpWidget(this,p);

	connect (ok,SIGNAL(pressed()),this,SLOT(okayPressed()) );
	connect (cancel,SIGNAL(pressed()),this,SLOT(cancelPressed()) );

	paintEvent(NULL);
}

blackHoleWarpDialog::~blackHoleWarpDialog()
{
	if (pw) delete pw;
	if (ok) delete ok;
	if (cancel) delete cancel;
}


void blackHoleWarpDialog::cancelPressed()
{
	QDialog::done(0);
}

void blackHoleWarpDialog::okayPressed()
{
	pw->getValue();
	QDialog::done(1);
}

void blackHoleWarpDialog::paintEvent(QPaintEvent* qp)
{
 	int w=pw->sizeHint().width();
	int h=pw->sizeHint().height();

	int w1=ok->sizeHint().width();
	int w2=cancel->sizeHint().width();
	int h1=ok->sizeHint().height();

	cancel->setGeometry(w-w2-5,h+5,w2,h1);
	ok->setGeometry(w-w2-w1-10,h+5,w1,h1);

	h+=h1+5;

	pw->setGeometry(0,0,w,h);
	setMinimumSize(w,h);
	setMaximumSize(w,h);
	if (qp) QDialog::paintEvent(qp);
}
