/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** transformdialog.cpp
*/
#include "transformdialog.h"
#include "transformdialog.moc"

#include <kapp.h>



TransformDialog::TransformDialog(QWidget *parent,const char *name,Vector3 *s,Vector3 *r,Vector3 *t) :
	QDialog(parent,name,TRUE)
{
	setCaption(name);

	vscale = s;
	vrotate = r;
	vtranslate = t;
	
	vscalesv = *s;
	vrotatesv = *r;
	vtranslatesv = *t;
	
	
	tfw = new TransformWidget(this,"");

	ok = new QPushButton( this,i18n("OK"));
	ok->setText(i18n("OK"));

	cancel = new QPushButton( this,i18n("Cancel"));
	cancel->setText(i18n("Cancel"));

	
	connect(ok,SIGNAL(clicked()),SLOT(saveData()));
	connect(ok,SIGNAL(clicked()),SLOT(accept()));
	connect(cancel,SIGNAL(clicked()),SLOT(restoreValues()));
	connect(cancel,SIGNAL(clicked()),SLOT(reject()));
	connect(tfw,SIGNAL(changed()),SLOT(saveData()));

	layout();
	
	loadData();
}

TransformDialog::~TransformDialog()
{
}

void	TransformDialog::layout()
{
	int	ww,hh,w,h;
	
	w = MAX(cancel->sizeHint().width(),ok->sizeHint().width());
	h = 25;
	ww = tfw->sizeHint().width();
	ww = MAX(ww,20 + w);
		
	hh = tfw->sizeHint().height() + 10 + h;
	
	setMaximumSize(ww,hh);
	QDialog::resize(ww,hh);
	setMinimumSize(ww,hh);


	tfw->setGeometry(0,0,ww,tfw->sizeHint().height());
	
	cancel->setGeometry(ww - 10 - w * 2,hh - h - 5,w,h);
	ok->setGeometry(ww - 5 - w,hh - h - 5,w,h);	

	tfw->layout();
}

void	TransformDialog::saveData()
{
	Vector3		v;
	
	tfw->save(*vscale,v,*vtranslate);
	
	v[0] *= PI / 180;
	v[1] *= PI / 180;
	v[2] *= PI / 180;
	*vrotate = v;
	
	emit changedData();
}

void	TransformDialog::loadData()
{
	Vector3		v;
	
	v = *vrotate;
	v[0] /= PI / 180;
	v[1] /= PI / 180;
	v[2] /= PI / 180;
	
	tfw->load(*vscale,v,*vtranslate);
}

void	TransformDialog::restoreValues()
{
	*vscale = vscalesv;
	*vrotate = vrotatesv;
	*vtranslate = vtranslatesv;
	
	emit changedData();
}


