/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** transformations.cpp
*/
#include "transformations.h"
#include <chunk.h>
 /* XPM */
const char*ScaleRotateTranslatePic[]={
"20 21 3 1",
"a c None", //#c0c0c0",
"# c #000000",
". c None",
"..........#aaaaaaaaa",
".###..###.#aaa.##aaa",
".##a..a##.#aa.aaa#aa",
".#a#..#a#.#a..aaaa#a",
".a.a##a.a.#a.aaaaa#a",
"....##....#a.a#.aa#a",
".#.#..#.#.#aa#aaa#aa",
".##....##.#a#.###aaa",
".###..###.#a.#aaaaaa",
"..........#aaaaaaaaa",
"####################",
"...#..a...#.........",
"..#....a..#.........",
".########.#.........",
"..#....a..#.........",
"..a#..#...#.........",
".a.....#..#.........",
"a########.#.........",
".a.....#..#.........",
"..a...#...#.........",
"...................."};

Transformations::Transformations(textureBase *p):textureBase(TRANSFORMATIONS,p)
{
	scale=Vector3(1,1,1);
	translate=Vector3(0,0,0);
	rotate=Vector3(0,0,0);
	setName("Transformations");
	setInfo((char *)"Transformations");
	setSubItems(false);

}

const char **Transformations::getXPM()
{
	return ScaleRotateTranslatePic;
}

void Transformations::updateInfo()
{
char *buffer=(char *)malloc(512);
	sprintf(buffer,"S(%g/%g/%g) T(%g/%g/%g) R(%g/%g/%g)",
		scale[0],scale[1],scale[2],
		translate[0],translate[1],translate[2],
		rotate[0],rotate[1],rotate[2]);
	setInfo(buffer);
	free(buffer);
}

Transformations::~Transformations()
{
}

void Transformations::setScaling(Vector3 v)
{
	scale=v;
	updateInfo();
}

void Transformations::setRotation(Vector3 v)
{
	rotate=v;
	updateInfo();
}

void Transformations::setTranslation(Vector3 v)
{
	translate=v;
	updateInfo();
}

Vector3 Transformations::getScaling()
{
	return scale;
}
Vector3 Transformations::getTranslation()
{
	return translate;
}

bool Transformations::canAdd(textureBase *tb)
{
	if (tb->getType()==TRANSFORMATIONS) return true;
	return false;
}

bool Transformations::isEqual(textureBase *tb)
{
Transformations *t=(Transformations *)tb;
	if (tb->getType()!=TRANSFORMATIONS) return false;

	if (
		(scale[0]==t->getScaling()[0])&&
		(scale[1]==t->getScaling()[1])&&
		(scale[2]==t->getScaling()[2])&&
		(rotate[0]==t->getRotation()[0])&&
		(rotate[1]==t->getRotation()[1])&&
		(rotate[2]==t->getRotation()[2])&&
		(translate[0]==t->getTranslation()[0])&&
		(translate[1]==t->getTranslation()[1])&&
		(textureBase::isEqual(tb)==true) &&
		(translate[2]==t->getTranslation()[2])
	) return true;
	return false;
}

void Transformations::add(textureBase *tb)
{
Transformations *t=(Transformations *)tb;
	if (tb->getType()!=TRANSFORMATIONS) return;

	scale[0]=t->getScaling()[0];
	scale[1]=t->getScaling()[1];
	scale[2]=t->getScaling()[2];
	rotate[0]=t->getRotation()[0];
	rotate[1]=t->getRotation()[1];
	rotate[2]=t->getRotation()[2];
	translate[0]=t->getTranslation()[0];
	translate[1]=t->getTranslation()[1];
	translate[2]=t->getTranslation()[2];
	updateInfo();
}


Vector3 Transformations::getRotation()
{
	return rotate;
}


int	Transformations::save(media *m)
{

chunk ch;
	if(!m)	return -1;
	#ifdef DEBUG
		printf("saving Transformations\n");
	#endif

	setMedia(m);

	writeChunk("TRNS");

	textureBase::save(m);

	ch.setMedia(m);
	ch.writeChunk("DSTR");
		writeVector(scale);
		writeVector(translate);
		writeVector(rotate);
	ch.writeChunkLen();

	writeChunkLen();

	#ifdef DEBUG
		printf("Transformations saved\n");
	#endif
	return 0;
}

int	Transformations::load(media *m,int l)
{
	char	chunk[4];
	bool 	read;
	int	len,pos = m->tell();


	#ifdef DEBUG
		printf("Loading Transformations\n");
	#endif

	if(!m) return -1;

	setMedia(m);	

	do {
		m->read(chunk,4);
		m->read(&len,4);
		read=false;
        	if(strncmp(chunk,"BASE",4) == 0) {
			textureBase::load(m,len);
			read=true;
		}
        	if(strncmp(chunk,"DSTR",4) == 0) {
			scale = readVector();
			translate = readVector();
			rotate = readVector();
			read=true;
		}
		if (read==false) { m->seek(len,SEEK_CUR); }
	} while (m->tell()< (pos+l) );
	


	
	m->seek(pos+l,SEEK_SET); // Man weiss ja nie...
	#ifdef DEBUG
		printf("Transformations loaded\n");
	#endif
	updateInfo();
	return 0;
}

int Transformations::exportPOV(FILE *fp,int tab,int tabsize, int anim,bool dummy)
{
	if(!fp) return -1;
	#ifdef DEBUG
		printf("exporting TRansformations (POV)\n");
	#endif

	if ((scale[0]!=1)||(scale[1]!=1)||(scale[2]!=1)) {
		printTab(fp,tab);
		fprintf(fp,"scale     <%g,%g,%g>\n",scale[0],scale[1],scale[2]);
	}
	if ((rotate[0]!=0)||(rotate[1]!=0)||(rotate[2]!=0)) {
		printTab(fp,tab);
		fprintf(fp,"rotate    <%g,%g,%g>\n",rotate[0] * 180 / PI,rotate[1] * 180 / PI,rotate[2] * 180 / PI);
	}
	if ((translate[0]!=0)||(translate[1]!=0)||(translate[2]!=0)) {
		printTab(fp,tab);
		fprintf(fp,"translate <%g,%g,%g>\n",translate[0],translate[1],translate[2]);
	}

	#ifdef DEBUG
		printf("Transformations exported (POV) saved\n");
	#endif
	return 0;
}

