/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** slopeentry.cpp
*/


#include "slopeentry.h"
#include <misc.h>
#include <stdio.h>
#include <chunk.h>

slopeEntry::slopeEntry(textureBase *p):textureBase(SLOPEENTRY,p)
{
	num=0;
	height=0;
	slope=0;
	setName("Slopeentry");
	setSubItems(false);
	updateInfo();

	addAddableItem(SLOPEENTRY,true);
}

void slopeEntry::updateInfo()
{
char *buffer=(char *)malloc(512);
	sprintf(buffer,"Num:%g Height:%g  Slope:%g",num,height,slope);
	setInfo(buffer);
	free(buffer);
}

slopeEntry::~slopeEntry()
{
}

bool slopeEntry::isEqual(textureBase *tb)
{
slopeEntry *se=(slopeEntry *)tb;
	if (!tb) return false;
	if (tb->getType()!=SLOPEENTRY) return false;
	if (
		(num==se->getSlopeNum() )&&
		(height==se->getSlopeHeight() )&&
		(slope==se->getSlope() )
	) return true;
	return false;
}

void	slopeEntry::setSlopeNum(double n)
{
	num=n;
	updateInfo();
}

double	slopeEntry::getSlopeNum()
{
	return num;
}

void	slopeEntry::setSlopeHeight(double n)
{
	height=n;
	updateInfo();
}

double	slopeEntry::getSlopeHeight()
{
	return height;
}


void	slopeEntry::setSlope(double n)
{
	slope=n;
	updateInfo();
}

double	slopeEntry::getSlope()
{
	return slope;
}


void slopeEntry::add(textureBase *tb)
{
slopeEntry *se=(slopeEntry*)tb;
	if (canAdd(tb)==false) return;
	slope=se->getSlope();
	height=se->getSlopeHeight();
	num=se->getSlopeNum();
	updateInfo();	
}

int	slopeEntry::save(media *m)
{
chunk ch;
	if(!m) return -1;
	#ifdef DEBUG
		printf("Saving SlopeEntry\n");
	#endif

	setMedia(m);
	
	writeChunk("SLPE");

	textureBase::save(m);
	
	ch.setMedia(m);
	ch.writeChunk("DATA");
		printf("******** %f  %f  %f\n",num,height,slope);
		m->write(&num,sizeof(double) );
		m->write(&height,sizeof(double) );
		m->write(&slope,sizeof(double) );
	ch.writeChunkLen();

	writeChunkLen();	

	#ifdef DEBUG
		printf("SlopeEntry saved\n");
	#endif

	return 0;
}

int	slopeEntry::load(media *m,int l)
{
	char	chunk[4];
	bool 	read;
	int	pos = m->tell(),len;

	if(!m)	return -1;

	setMedia(m);

	#ifdef DEBUG
		printf("loading SlopeEntry\n");
	#endif

	do {
		m->read(chunk,4);
		m->read(&len,4);
		read=false;
		if(strncmp(chunk,"BASE",4) == 0) {
			textureBase::load(m,len);
			read=true;
		}
		if(strncmp(chunk,"DATA",4) == 0) {
			m->read(&num,sizeof(double));
			m->read(&height,sizeof(double));
			m->read(&slope,sizeof(double));
			read=true;
		}
		if (read==false) { m->seek(len,SEEK_CUR); }

	} while (m->tell()< (pos+l) );

	m->seek(pos+l,SEEK_SET); // Man weiss ja nie...

	#ifdef DEBUG
		printf("SlopeEntry loaded\n");
	#endif
	updateInfo();
	return 0;
}

int	slopeEntry::exportPOV(FILE *fp,int tab,int tabsize,int a,bool dummy)
{
	if(!fp) return -1;
	#ifdef DEBUG
		printf("exporting SlopeEntry (POV)\n");
	#endif

	printTab(fp,tab);
		fprintf(fp,"[ %g  <%g,%g> ]",num,height,slope);
	fprintf(fp,"\n");

	#ifdef DEBUG
		printf("SlopeEntry exported (POV)\n");
	#endif
	return 0;
}