/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** bumpmap.cpp
*/
#include "bumpmap.h"

#include "../classes/imageconverter.h"

bumpMap::bumpMap(textureBase *p):textureBase(BUMPMAP,p)
{

	#ifdef DEBUG
		printf("entering Bumpmap-Constructor\n");
	#endif
	Filename=NULL;
	Filetype=NULL;

	bumpSize=1;
	useColor=false;

	realFileName=NULL;
	realFileType=NULL;

	#ifdef DEBUG
		printf("leaving Bumpmap-Constructor\n");
	#endif

	picData=NULL;
	picLen=0;

	setName("Bumpmap");
	setInfo((char *)"Bumpmap");
	setSubItems(false);

	addAddableItem(BUMPMAP,false);
}

void bumpMap::updateInfo()
{
char buffer[1024];

	if (Filename) sprintf(buffer,"File:%s (%s)",Filename,Filetype);
	else sprintf(buffer,"no File selected");
	setInfo(buffer);
}

bitmapmodifier *bumpMap::getModifier()
{
	return &modifier;
}

void bumpMap::add(textureBase *t)
{
bumpMap *b=(bumpMap *)t;
	if (!t) return;
	setBumpMapFilename( b->getBumpMapFilename() );
	setBumpMapFiletype( b->getBumpMapFiletype() );
	setBumpSize ( b->getBumpSize() );
	if (b->getBumpUseColor()==true) setBumpUseColor();
	else setBumpUseIndex();
	modifier.add( (textureBase *)b->getModifier() );
	updateInfo();
}



bool bumpMap::isEqual(textureBase *t)
{
bumpMap *b;
	if (!t) return false;
	if (textureBase::isEqual(t)==false) return false;
	if (t->getType()!=BUMPMAP) return false;

	b=(bumpMap*)t;

	if ( (getBumpMapFilename()==NULL)&&(b->getBumpMapFilename()!=NULL) ) return false;
	if ( (getBumpMapFilename()!=NULL)&&(b->getBumpMapFilename()==NULL) ) return false;

	if( (b->getBumpMapFiletype()!=NULL)&&(getBumpMapFiletype()==NULL) )  return false;
	if( (b->getBumpMapFiletype()==NULL)&&(getBumpMapFiletype()!=NULL) )  return false;


	if( (b->getBumpMapFiletype()==NULL)&&(getBumpMapFiletype()!=NULL)&&(getBumpMapFilename()!=NULL)&&(b->getBumpMapFilename()==NULL) ) {
		if (!(
			 (!(strcmp(getBumpMapFilename(),b->getBumpMapFilename()))) &&
			 (!(strcmp(getBumpMapFiletype(),b->getBumpMapFiletype())))		
		)) return false;
        }

	if (
		( getBumpSize()==b->getBumpSize() ) &&
		( getBumpUseColor()==b->getBumpUseColor() )
	) return true;

	return false;
}

bumpMap::~bumpMap()
{
char buffer[1024];
	if (realFileName) {
		sprintf(buffer,"rm %s",realFileName);
		system(buffer);
	}
	if (Filename!=NULL) {free((void *)Filename);}
	if (Filetype!=NULL) {free((void *)Filetype);}
}

const char *bumpMap::getBumpMapFilename()
{
	return Filename;
}

const char *bumpMap::getBumpMapFiletype()
{
	return Filetype;
}

void bumpMap::setBumpMapFilename(const char *n)
{
	if (!n) return;
	if (Filename!=NULL) {free( (void*) Filename);}
	Filename=strdup(n);
	updateInfo();
}

void bumpMap::setBumpMapFiletype(const char *n)
{
	if (!n) return;
	if (Filetype!=NULL) { free( (void*) Filetype); }
	Filetype=strdup(n);
	updateInfo();
}

double bumpMap::getBumpSize()
{
	return bumpSize;
}

void bumpMap::setBumpSize(double n)
{
	 bumpSize=n;
	updateInfo();
}

void bumpMap::setBumpUseColor()
{
	 useColor=true;
	updateInfo();
}

void bumpMap::setBumpUseIndex()
{
	 useColor=false;
	updateInfo();
}

bool bumpMap::getBumpUseColor()
{
	 return useColor;
}

bool bumpMap::getBumpUseIndex()
{
	 return !useColor;
}



int bumpMap::save(media *m)
{
chunk ch;
	if (!m) return -1;
	#ifdef DEBUG
		printf("saving BumpMap\n");
	#endif

	setMedia(m);

	writeChunk("BMPM");

	textureBase::save(m);
	ch.setMedia(m);
	ch.writeChunk("DATA");
		writeName(Filename);
		writeName(Filetype);

		m->write(&bumpSize,sizeof(double));	
		m->write(&useColor,sizeof(bool));
	ch.writeChunkLen();

	if ((picData)&&(picLen>0)) {
		ch.writeChunk("PDAT");
	       	m->write(picData,picLen );	
		ch.writeChunkLen();
		ch.writeChunkLen();
	}

	modifier.save(m);

	writeChunkLen();
	
		
	#ifdef DEBUG
		printf("BumpMap saved\n");
	#endif
	return 0;
}


int bumpMap::load(media *m, int l)
{
	int 	pos=m->tell(),len;
	char chunk[4];
	bool read;

	if (!m) return -1;

	#ifdef DEBUG
		printf("loading BumpMap\n");
	#endif

	setMedia(m);

	if (picData) free(picData);
	picData=NULL;


	do {
		m->read(&chunk,4);
		m->read(&len,4);
		read=false;

		if(strncmp(chunk,"BITM",4) == 0) {
			modifier.load(m,len);
			read=true;
		}
		if(strncmp(chunk,"BASE",4) == 0) {
			textureBase::load(m,len);
			read=true;
		}
		if(strncmp(chunk,"DATA",4) == 0) {
			Filename=readName();
			Filetype=readName();
			m->read(&bumpSize,sizeof(double));
			m->read(&useColor,sizeof(bool));
			read=true;
		}
		if(strncmp(chunk,"PDAT",4) == 0) {
			picData=(char*)malloc(len);
		       	m->read(&picData,len );
			read=true;
		}
		if(strncmp(chunk,"BASE",4) == 0) {
			textureBase::load(m,len);
			read=true;
		}
		if (read==false) { m->seek(len,SEEK_CUR); }

	} while (m->tell()< (pos+l) );



	m->seek(pos+l,SEEK_SET); // Man weiss ja nie...

	#ifdef DEBUG
		printf("Bumpmap loaded\n");
	#endif
	updateInfo();
	return 0;
}

bool bumpMap::isExportable()
{
FILE *f=NULL;

	if (Filename){
		f=fopen(Filename,"r");
		if (f==NULL) {return false;}
		fclose(f);
		//printf("FILENAME:%s\n",Filename);
	} else return false;
	if (bumpSize==0) return false;	
	return true;
}

int bumpMap::exportPOV(FILE *fp, int tab, int tabsize, int a,bool d)
{
	char	buffer[1024];
	
	if(realFileName)
	{
		sprintf(buffer,"rm %s",realFileName);
		system(buffer);
	}

	#ifdef DEBUG
		printf("exporting BumpMap (POV)\n");
	#endif

	if (picData) {


	//if ((Filename)&&(strcmp(Filename,"")!=0)) {
		printTab(fp,tab);

		fprintf(fp,"bump_map {\n");
		printTab(fp,tab+tabsize);

	        if(getImageConverter())
	        {
			if(((strncmp(getImageConverter()->getType(Filename),"PNG",3)))||((strncmp(getImageConverter()->getType(Filename),"JPEG",4))))
			{
				realFileName = getImageConverter()->convert(Filename,0,0);
				realFileType = getImageConverter()->getExtension();
				fprintf(fp,"%s \"%s\"\n",realFileType,realFileName);
			}
			else
			{
				fprintf(fp,"%s \"%s\"\n",Filetype,Filename);
			}
		}
		else
		{
			fprintf(fp,"%s \"%s\"\n",Filetype,Filename);
		}

		if (bumpSize!=1) {
			printTab(fp,tab+tabsize);
			fprintf(fp,"bump_size %g\n",bumpSize);
		}
	
		modifier.exportPOV(fp,tab,tabsize,a);
        	
		textureBase::exportPOV(fp,tab,tabsize,a,d);
	
		printTab(fp,tab);
		fprintf(fp,"}\n");


	//} else {return 1;}
	}

	#ifdef DEBUG
		printf("BumpMap exported (POV)\n");
	#endif
	return 0;
}
