/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** quadric.cpp
*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "num.h"
#include "math.h"
#include "quadric.h"

quadric::quadric(base *p,char *n ):csgobj(p,n)
{
int i,j;
	numtype = NUM_QUADRIC;
	for (i=0;i<3;i++) for (j=0;j<3;j++) {koeff[i][j]=0;}
	k=0;
	if (parent) addToParent(parent);
}

quadric::~quadric()
{
}

int quadric::addToParent(base *p) 
{ 
	if (!p) return -2; 
	return p->addChild(this); 
} 
 
void quadric::dumpNames(int tab,int) 
{ 
	printTab(stderr,tab); 
	printf("poly: %s\n", name); 
} 

void quadric::SetKoeff(int x, int y, double k)
{
	koeff[x][y]=k;
}

void quadric::SetOffset(double a)
{
	k=a;
}

int	quadric::exportPOV(FILE *fp,int tab,int tabsize,int anim)
{
	if(isFlag(NO_EXPORT)) return 0;

	printTab(fp,tab);
	fprintf(fp,"// Objectname = %s\n",name);
	printTab(fp,tab);
	fprintf(fp,"// Objecttype = quadric\n");
	printTab(fp,tab);
	fprintf(fp," quadric { <%f, %f, %f>, <%f, %f, %f>, <%f, %f, %f>, %f }\n",koeff[0][0], koeff[1][0], koeff[2][0], koeff[0][1], koeff[1][1], koeff[2][1], koeff[0][2], koeff[1][2], koeff[2][2],k);

	dim::exportPOV(fp,tab,tabsize,anim);

	printTab(fp,tab);
	fprintf(fp,"}\n\n");

	return 0;
}

int	quadric::save(FILE *fp)
{
	int i,j;

	if (!fp) return -1;	
	setFile(fp);

	writeChunk("QUAD");
	SN(name);

	saveFlags(fp);

	SD(k);
	for(i = 0;i < 3;i++)
	{
		for(j = 0;j < 3;j++)
		{
			SD(koeff[i][j]);
		}
	}
	
	anim::save(fp);
	dim::save(fp);

	writeChunkLen();

	return 0;
}

int	quadric::load(FILE *fp,int l)
{
	int i,j,pos = ftell(fp);

	loadFlags(fp,l);

	k = readDouble(fp);
	for(i = 0;i < 3;i++)
	{
		for(j = 0;j < 3;j++)
		{
			koeff[i][j] = readDouble(fp);
		}
	}

	anim::load(fp,l -(ftell(fp) - pos));
	dim::load(fp,l -(ftell(fp) - pos));

	return 0;
}





