#!/bin/sh

function getbasename()
{
	getbasename_c=20
	getbasename_n=`echo $1 | cut -d/ -f$getbasename_c`
	getbasename_tmp=$getbasename_n
	while test $getbasename_c -gt 1 -a -z "$getbasename_tmp"
	do
		getbasename_c=`expr $getbasename_c - 1`
		getbasename_tmp=`echo $1 | cut -d/ -f$getbasename_c`
	done

	echo $getbasename_tmp
}

function calcsize()
{
	cst=`expr $1 - 1`
	cst=`expr $cst \/ 16`
	cst=`expr $cst + 1`
	cst=`expr $cst \* 16`

	echo $cst
}

	
if test $# -ge 2
then
	W=`calcsize $1`
	H=`calcsize $2`
else
	W=112
	H=112
fi

if test $# -ge 3
then
	basename=$3
fi

n=0
for i in $basename*.pov
do
	name=`getbasename $i`

	n=`expr $n + 1`
	echo "Render frame $n ($name)"
	if test -f $basename$n.ppm
	then
		echo $basename$n.ppm exist
	else
		povray +W$W +H$H +FP +I$i +O$basename$n.ppm 2> /dev/null
	fi
	ppmtoyuvsplit $basename$n $basename$n.ppm
	rm $basename$n.ppm
done

mpeg -a 1 -b $n -h $W -v $H -s $basename.mpg $basename
rm *.Y *.U *.V

