// fish.cpp

#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#define MAX(a,b)	(a < b ? b : a)
#define MIN(a,b)	(a > b ? b : a)
#define RANGE(a,b,c)	(MIN(c,MAX(a,b)))
#define SQR(a)		((a) * (a))
#define SQRT(a)		sqrt(a)

#define SIZE		20
#define TILES		2

float fish(float x,float,float z)
{
	float r0,r1,r2,r3;
	
	x = x - floor(x);
	z = z - floor(z);
	
	r0 = SQRT(SQR(x - 0.5) + SQR(z - 0));
	r1 = SQRT(SQR(x - 0) + SQR(z - 0.5));
	r2 = SQRT(SQR(x - 1) + SQR(z - 0.5));
	r3 = SQRT(SQR(x - 0.5) + SQR(z - 1));
	if(r0 <= 0.5)
		return r0;
	if(r1 <= 0.5)
		return r1;
	if(r2 <= 0.5)
		return r2;
	return r3;
}

void	main()
{
	int	x,z,i;
	char	cm[20] = "ffff .,+*x8Wffff";
	
	for(z = 0;z < SIZE * TILES;z++)
	{
		for(x = 0;x < SIZE * TILES;x++)
		{
			i = 4 + (int)(15 * fish((float)x / SIZE,0,(float)z / SIZE));
			printf("%c",cm[i]);
		}
		printf("\n");
	}
}
