/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** evaluate.h
*/
#ifndef	__EVALUATE_H__
#define __EVALUATE_H__

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <math.h>

#include <misc.h>

#define BOOL(a)			((a) == 0?0:1)
#define DOUBLE_TO_BOOL(a)	((a) == 0?0:1)

#ifndef MIN
#define MIN(a,b)		((a) < (b)?(a):(b))
#endif
#ifndef MAX
#define MAX(a,b)		((a) > (b)?(a):(b))
#endif
#ifndef DEGREE
#define DEGREE(a)		((a) / 180 * PI)
#endif

typedef struct
	{
		int		ntuple;
		double		*tuple;
	}
	ntuple_t;

typedef struct
	{
		char		*name;
		double		value;
	}
	param_t;

typedef struct
	{
		int		nparam;
		param_t		*param;
	}
	paralist_t;



/*
** This is a automatically generated prototypefile
**
** Generated by genprot V0.5 by Tobias Wollgam
*/

/* Prototypes from evaluate.c */

int		eval_number(const char *term,double *result);
char		*get_next_operator(char *term,char *ops);
char		*get_left_term(void);
char		*get_right_term(void);
char		*get_function_name(char *term);
char		*get_subterm(void);
char		*format_term(char *term);
int		add_tuple(ntuple_t *tuple,double d);
char		**get_simple_terms(char *term);
ntuple_t	*eval_term(char *term_unformated,paralist_t *plist);
void		add_param(paralist_t *list,const char *name,double value);
void		set_param(paralist_t *list,const char *name,double value);
int		exist_param(paralist_t *list,const char *name);
double		get_param(paralist_t *list,const char *name);
void		copy_paralist(paralist_t*,paralist_t*);
void		kill_paralist(paralist_t *list);

#endif

