/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** treelist.h
*/
#ifndef __TREEVIEW_H__
#define __TREEVIEW_H__

#include <qpopmenu.h>
#include <qlistview.h>
#include <qdragobject.h>
#include <qdropsite.h>
#include <qlineedit.h>

class TreeListItem : public QListViewItem
{
public:
	TreeListItem(QListView *p,int h);
	TreeListItem(QListView *p,const char* t1,int h);
	TreeListItem(QListViewItem *p,int h);
	TreeListItem(QListViewItem *p,const char* t1,int h);
	
	void		setHeight(int h);

	void		setup();
	
	void		clear();
	
//	const char	*key(int,bool);
};

class TreeList : public QListView, public QDropSite
{
Q_OBJECT
protected:
	int			mxo,myo,button,dragging;
	QTextDrag		*td;
        int			dragdeltamin;
	QLineEdit 		*renameEdit;

public:
	TreeList(QWidget *p,char* n=0);
	~TreeList();

	void		addChildItem(QListViewItem *p,QListViewItem *c);
	QListViewItem*	getRoot();
	void		addToRoot(QListViewItem *nr);

	QListViewItem*	findItem(QString);
	
	void		setDragDeltaMin(unsigned int);
	int		getDragDeltaMin();

protected:
	QListViewItem*	findItem(QListViewItem*,QString);

	void		mouseMoveEvent(QMouseEvent *me);
	void		mousePressEvent(QMouseEvent *me);
	void		mouseReleaseEvent(QMouseEvent *me);

	virtual void	dragEnterEvent(QDragEnterEvent *de);
	virtual void	dragLeaveEvent(QDragLeaveEvent *de);
	virtual void	dragMoveEvent(QDragMoveEvent *de);
	virtual void	dropEvent(QDropEvent *de);

	virtual void	startDragCopy(QListViewItem *item,QWidget *dragsource);
	virtual void	startDragMove(QListViewItem *item,QWidget *dragsource);

signals:
	void		popupMenu(QListViewItem*,int,int);
};

#endif

