/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** tabwidget.cpp
*/

#include "tabwidget.h"
#include "tabwidget.moc"
#include <misc.h>
#include <stdio.h>


TabWidget::TabWidget(QWidget *parent,const char *name,int m,QWidget *sample=NULL) :
	QWidget(parent,name)
{
	mode=m;

	wstack=new QWidgetStack(this);
	if (mode==0)
	{
		tab=new QTabBar(this);
		connect(tab,SIGNAL(selected(int)),this,SLOT(selected(int)) );
	}
	else
	{
		combo=new QComboBox(this);
		label=new QLabel(name,this);
		connect(combo,SIGNAL(activated(int)),this,SLOT(selected(int)) );
	}
	wstack->setFrameStyle(QFrame::Panel|QFrame::Raised);
	sel=0;

	if (sample)
	{
		innerWidth=sample->sizeHint().width();
		innerHeight=sample->sizeHint().height();
	}
	else
	{innerWidth=0;innerHeight=0;}

	layoutTab=-1;
	paintEvent(NULL);
}

void TabWidget::setSize(int w,int h)
{
	innerWidth=w;
	innerHeight=h;
	paintEvent(NULL);
}

void TabWidget::setSize( QWidget *wi,int width, int height)
{
}


void TabWidget::addWidget(QWidget *w,int nr,char *label)
{

	wstack->addWidget(w,nr);
	widgetlist.append(w);
 	if (mode==0) {
		QTab *t=new QTab();
		t->label=label;
		t->id=nr;
		tab->addTab(t);
	} else {
		combo->insertItem(label,nr);
	}

	wstack->raiseWidget(w);
	emit itemChanged();
}

void TabWidget::addWidget(QWidget *wi,int nr,const char *label,int w,int h)
{
}

void TabWidget::select(int nr)
{
	sel=nr;
	wstack->raiseWidget(nr);
	if (mode==0) tab->setCurrentTab(nr);
	else combo->setCurrentItem(nr);
	sizeHint();
}

void TabWidget::selected(int nr)
{
	
	wstack->raiseWidget(nr);
	sel=nr;
	sizeHint();
	emit itemChanged();
}

TabWidget::~TabWidget()
{
}

int TabWidget::getSelected()
{
	return sel;
}

QSize TabWidget::sizeHint() const
{
	return qs;
}

int TabWidget::getLayoutTab()
{
	return label->sizeHint().width()+5;
}

void TabWidget::setLayoutTab(int t)
{
	layoutTab=t;
}

void TabWidget::paintEvent(QPaintEvent* qp)
{
QWidget *wid=wstack->widget(sel);
int h2,w2,w3,w,h;

        if (wid) {
		wstack->raiseWidget(sel);
		if (mode==0) tab->setCurrentTab(sel);
		else combo->setCurrentItem(sel);
	}

	if (mode==0) {
		h2=tab->sizeHint().height();
		w2=tab->sizeHint().width();
		tab->setGeometry(0,0,w2,h2);
		wstack->setGeometry(0,h2-1,MAX(innerWidth,w2),innerHeight-2);

                w=MAX(innerWidth,w2);
		h=h2+innerHeight+5;
		qs.setWidth(w);
		qs.setHeight(h);

	} else {
		h2=combo->sizeHint().height();
		w2=label->sizeHint().width();
		w3=combo->sizeHint().width();

		label->setGeometry(0,0,w2,h2);

 		if (layoutTab==-1) combo->setGeometry(w2+5,0,w3,h2); 	
 		else combo->setGeometry(layoutTab,0,w3,h2); 	

		wstack->setGeometry(0,h2+5,innerWidth,innerHeight);

                w=MAX(innerWidth,w2+5+w3);
		h=h2+5+innerHeight+5;
		qs.setWidth(w);
		qs.setHeight(h);
	}
	if (qp) QWidget::paintEvent(qp);
}
