/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/

#ifndef __TEXTURETOOLBAR_H__
#define __TEXTURETOOLBAR_H__

#include <ktoolbar.h>

#include "../../3d/textures/texturebase.h"
#include "../../3d/textures/texturelibrary.h"
#include "../../3d/textures/normalmap.h"
#include "../../3d/textures/normallist.h"
#include "textureview.h"

#define MPopupMenu	QPopupMenu


class TextureToolBar : public  KToolBar
{
Q_OBJECT
protected:
	MPopupMenu		*MPigment,*MNormal,*MFinish,*MInterior,*MBook,*MSurface;
	textureBase		*selTexture,*tlib;
	TextureView		*tview;

public:
	TextureToolBar(QWidget *p, TextureView *l);
	~TextureToolBar();

//	void	paintEvent(QPaintEvent*);

public slots:
	void	sel(int);
	void 	newTextureSel(textureBase *);
	void 	setLibrary(TextureLibrary *);
signals:
	void 	update();

};

#endif

