/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** surfacelistdialog.cpp
*/
#include "surfacelistdialog.h"
#include "surfacelistdialog.moc"

#include <kapp.h>
#include <qtooltip.h>

SurfaceListWidget::SurfaceListWidget(QWidget *parent,surfaceList *c) :
	TextureWidgetBase(parent,"SurfacelistWidget")
{

	co=c;

	tbasew=new TextureBaseWidget(this,co);	
	connect(tbasew,SIGNAL(valueChanged()),this,SIGNAL(valueChanged()) );

	combobox=new QComboBox(this);
	combobox->insertItem(i18n("Brick"));
	combobox->insertItem(i18n("Checker"));
	combobox->insertItem(i18n("Hexagon"));
	combobox->setCurrentItem((int)co->getSurfaceListFunction());
	l=new QLabel(i18n("Pattern:"),this);
#if (USE_QTOOLTIP == 1)
	QToolTip::add(combobox,i18n("Pattern of the Surfacelist") );
#endif
	connect(combobox,SIGNAL(highlighted(int)),this,SIGNAL(valueChanged()) );

	paintEvent(NULL);
}


SurfaceListWidget::~SurfaceListWidget()
{
}

void SurfaceListWidget::getValue()
{
	tbasew->getTextureBase();
	switch(combobox->currentItem()) {
		case 0:
			co->setSurfaceListFunction((surfaceList::FUNCTION)0);
		break;
		case 1:
			co->setSurfaceListFunction((surfaceList::FUNCTION)1);
		break;
		case 2:
			co->setSurfaceListFunction((surfaceList::FUNCTION)2);
		break;
	}
}

QSize SurfaceListWidget::sizeHint() const
{
	return qs;
}

void SurfaceListWidget::paintEvent(QPaintEvent* qp)
{
int w=tbasew->sizeHint().width()+10;
int h=tbasew->sizeHint().height();
int y=0,w1=0,w2=0,h1=0;
	
	tbasew->setGeometry(10,10,w,h);
	y+=15+h;

	w1=l->sizeHint().width()+5;
	h1=combobox->sizeHint().height();

	l->setGeometry(5,y,w1,h1);

	w2=combobox->sizeHint().width()+5;

	combobox->setGeometry(5+w1,y,w2,h1);	
	
	w=MAX(w,w1+5+w2);
	y+=h+5;

	qs.setWidth(w+5);
	qs.setHeight(y+5);
	if (qp) QWidget::paintEvent(qp);
}

//------------------------------------------------------------------------

SurfaceListDialog::SurfaceListDialog(QWidget *parent,surfaceList *cl) :
	QDialog(parent,"SurfaceListDialog",true)
{
	setCaption(i18n("Surfacelist") );

	ok=new QPushButton(i18n("Ok"),this);
	cancel=new QPushButton(i18n("Cancel"),this);

	pw=new SurfaceListWidget(this,cl);

	connect (ok,SIGNAL(pressed()),this,SLOT(okayPressed()) );
	connect (cancel,SIGNAL(pressed()),this,SLOT(cancelPressed()) );

	paintEvent(NULL);
}

SurfaceListDialog::~SurfaceListDialog()
{
	if (ok) delete ok;
	if (cancel) delete cancel;
	if (pw) delete pw;
}


void SurfaceListDialog::cancelPressed()
{
	QDialog::done(0);
}

void SurfaceListDialog::okayPressed()
{
	pw->getValue();
	QDialog::done(1);
}

void SurfaceListDialog::paintEvent(QPaintEvent* qp)
{
	int w=pw->sizeHint().width();
	int h=pw->sizeHint().height();

	int w1=ok->sizeHint().width();
	int w2=cancel->sizeHint().width();
	int h1=ok->sizeHint().height();

	cancel->setGeometry(w-w2-5,h+5,w2,h1);
	ok->setGeometry(w-w2-w1-10,h+5,w1,h1);

	pw->setGeometry(0,0,w,h);
	setMinimumSize(w,h);
	setMaximumSize(w,h);
	if (qp) QDialog::paintEvent(qp);
}