/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** slopeentrywidget.h
*/
#ifndef __SLOPEENTRYWIDGET_H__
#define __SLOPEENTRYWIDGET_H__


#include <qwidget.h>
#include <qgroupbox.h>
#include <qpainter.h>
#include <qlineedit.h>
#include <qcheckbox.h>

#include "../../3d/textures/slopeentry.h"
#include "../widgets/spinbox.h"
#include "../widgets/percentwidget.h"
#include "texturebasewidget.h"
#include "texturewidgetbase.h"

class SlopeEntryWidget : public TextureWidgetBase
{
Q_OBJECT
protected:
	slopeEntry *se;
	SpinBox			*value,*heigh,*slope;
        TextureBaseWidget	*tbasew;
	QSize			qs;
	
public:

	SlopeEntryWidget(QWidget *p, slopeEntry *);
	~SlopeEntryWidget();
	void getValue();
	
	virtual QSize	sizeHint() const;
	void	paintEvent(QPaintEvent*);
};
//----------------------------------------------------


class SlopeEntryDialog : public QDialog
{
Q_OBJECT
protected:

	QPushButton		*ok,*cancel;
	SlopeEntryWidget		*pw;

public:

	SlopeEntryDialog(QWidget *p, slopeEntry *);
	~SlopeEntryDialog();

protected:
	void	paintEvent(QPaintEvent*);
public slots:
	void okayPressed();
	void cancelPressed();
};
#endif
