/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** slopeentrywidget.cpp
*/

#include "slopeentrywidget.h"
#include "slopeentrywidget.moc"

#include <kapp.h>


SlopeEntryWidget::SlopeEntryWidget(QWidget *parent,slopeEntry *s) :
	TextureWidgetBase(parent,"SlopeEntryDialog")
{
	se=s;
	
	tbasew=new TextureBaseWidget(this,se);
	connect(tbasew,SIGNAL(valueChanged()),this,SIGNAL(valueChanged()) );

	value=new SpinBox(this,i18n("Value:"),se->getSlopeNum());
#if (USE_QTOOLTIP == 1)
	QToolTip::add(value,i18n("Tip not yet avaiable") );
#endif
	value->DownTopValue(0,1);
	connect(value,SIGNAL(valueChanged()),this,SIGNAL(valueChanged()) );

	heigh=new SpinBox(this,i18n("Height:"),se->getSlopeHeight());
#if (USE_QTOOLTIP == 1)
	QToolTip::add(heigh,i18n("The height of of the slope") );
#endif
	heigh->DownTopValue(-3,3);
	connect(heigh,SIGNAL(valueChanged()),this,SIGNAL(valueChanged()) );

	slope=new SpinBox(this,i18n("Slope:"),se->getSlope());
#if (USE_QTOOLTIP == 1)
	QToolTip::add(slope,i18n("Tip not yet avaiable") );
#endif
	slope->DownTopValue(-3,3);
	connect(slope,SIGNAL(valueChanged()),this,SIGNAL(valueChanged()) );

	paintEvent(NULL);
}

void SlopeEntryWidget::getValue()
{
	se->setSlopeNum(value->getValue());
	se->setSlopeHeight(heigh->getValue());
	se->setSlope(slope->getValue());
	tbasew->getTextureBase();
}

SlopeEntryWidget::~SlopeEntryWidget()
{
	if (tbasew) delete tbasew;
	if (value) delete value;
	if (heigh) delete heigh;
	if (slope) delete slope;
}

QSize SlopeEntryWidget::sizeHint() const
{
	return qs;
}

void SlopeEntryWidget::paintEvent(QPaintEvent* qp)
{
int w=tbasew->sizeHint().width();
int h=tbasew->sizeHint().height();
int y=0,w2=0,w3=0;

	tbasew->setGeometry(10,10,w,h);
	y+=15+h;

	value->layout(value,heigh,slope);

	h=value->sizeHint().height();
	w2=value->sizeHint().width();
	value->setGeometry(10,y,w2,h);
	y+=h+15;

	h=value->sizeHint().height();
	w2=heigh->sizeHint().width();

	heigh->setGeometry(10,y,w2,h);
	y+=h+5;

	w2=slope->sizeHint().width();
	slope->setGeometry(10,y,w2,h);

	if ((w2+w3+10)>w) w=w2+w3+10;
	y+=h+5;
	
	qs.setHeight(y+5);
	qs.setWidth(w+5);

	if (qp) QWidget::paintEvent(qp);
}
//------------------------------------------------------------------------

SlopeEntryDialog::SlopeEntryDialog(QWidget *parent,slopeEntry *s) :
	QDialog(parent,"SlopeEntryDialog",true)
{

	setCaption("Slopemap-Entry");
	ok=new QPushButton("Ok",this);
	cancel=new QPushButton("Cancel",this);

	pw=new SlopeEntryWidget(this,s);

	connect (ok,SIGNAL(pressed()),this,SLOT(okayPressed()) );
	connect (cancel,SIGNAL(pressed()),this,SLOT(cancelPressed()) );

	paintEvent(NULL);
}

SlopeEntryDialog::~SlopeEntryDialog()
{
	if (ok) delete ok;
	if (cancel) delete cancel;
	if (pw) delete pw;
}


void SlopeEntryDialog::cancelPressed()
{
	QDialog::done(0);
}

void SlopeEntryDialog::okayPressed()
{
	pw->getValue();
	QDialog::done(1);
}

void SlopeEntryDialog::paintEvent(QPaintEvent* qp)
{
	int w=pw->sizeHint().width();
	int h=pw->sizeHint().height();

	int w1=ok->sizeHint().width();
	int w2=cancel->sizeHint().width();
	int h1=ok->sizeHint().height();

	cancel->setGeometry(w-w2-5,h+5,w2,h1);
	ok->setGeometry(w-w2-w1-10,h+5,w1,h1);

	pw->setGeometry(0,0,w,h);

	setMinimumSize(w,h);
	setMaximumSize(w,h);

	QDialog::paintEvent(qp);
}
