/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** densitydialog.h
*/
#ifndef __DensityWidget_H__
#define __DensityWidget_H__


#include <qwidget.h>
#include <qgroupbox.h>
#include <qpainter.h>
#include <qcolor.h>
#include <qcombobox.h>
#include <kcolorbtn.h>
#include <qdialog.h>
#include <qlineedit.h>
#include <qcheckbox.h>

#include <color.h>
#include "../../3d/textures/density.h"
#include <qcolor.h>
#include "../widgets/spinbox.h"
#include "../widgets/percentwidget.h"
#include "colorentrywidget.h"
#include "patternmodifierdialog.h"

#include "texturewidgetbase.h"

class PatternModifierWidget;
class DensityWidget : public TextureWidgetBase
{
Q_OBJECT
protected:

	Density *de;

	TextureBaseWidget	*tbasew;
	PatternModifierWidget 	*pmd;
	QSize				qs;

public:

	DensityWidget(QWidget *p, Density *);
	~DensityWidget();

	void 	getValue();
	virtual QSize	sizeHint() const;
	void	paintEvent(QPaintEvent*);
};

//--------------------------------------------------------

class DensityDialog : public QDialog
{
Q_OBJECT
protected:

	QPushButton		*ok,*cancel;
	DensityWidget		*pw;

public:

	DensityDialog(QWidget *p, Density *);
	~DensityDialog();
	void	paintEvent(QPaintEvent*);
public slots:
	void okayPressed();
	void cancelPressed();
};




#endif
