/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** preferences.h
*/
#ifndef __PREFERENCES_H__
#define __PREFERENCES_H__



#include <ksimpleconfig.h>
#include <qcolor.h>
#include <qstring.h>
#include <list.h>

class Preferences
{
protected:

	// Pfade
	
	QString		texturePath;
	QString		bumpMapPath;
	QString		imageMapPath;
	QString		dataPath;
	QString		fontPath;
	QString		heightfieldPath;

	QString		tempPath;
	QString		imagePath;
	QString 	animationPath;

	QString 	RenderProgram;
	QString		RenderProgramParam1;
	QString		RenderProgramParam2;
	QString		RenderProgramParam3;
	QString 	RenderSmallPreviewProgram;
	QString		RenderSmallPreviewProgramParam1;
	QString		RenderSmallPreviewProgramParam2;
	QString		RenderSmallPreviewProgramParam3;
	QString 	RenderPreviewProgram;
	QString		RenderPreviewProgramParam1;
	QString		RenderPreviewProgramParam2;
	QString		RenderPreviewProgramParam3;

	QString		defaultTextureFile;

	QColor		GridColor, XAxisColor, YAxisColor, ZAxisColor;
	QColor		BackgroundColor, LinesColor, SelectedLinesColor;
	QColor		BlobColor, BoxColor;
	QColor		LetterXColor, LetterYColor,LetterZColor;

	bool		DrawAxes;
	
	int		RenderPreview;
	int		PreviewSize;
	int 		activeRenderProgramParam;	
	int 		activeRenderPreviewProgramParam;	
	int 		activeRenderSmallPreviewProgramParam;	

	int		screen_width,screen_height;	// in mm
	int		res_width,res_height;		// in pixel

	int		mainwin_width,mainwin_height;
	int		animeditor_width,animeditor_height;

	int		gridlines_xy,gridlines_xz,gridlines_zy;
	int		gridpoints_xy,gridpoints_xz,gridpoints_zy;
	double		gridspace_xy,gridspace_xz,gridspace_zy;
 	int		grid_xy,grid_xz,grid_zy;

	int		num_recentfiles,check_existance;
	QStrList	recentfiles;
	
	bool		autosaverendered;
	
	KSimpleConfig	*cfg;

	QStrList	clusterHosts;
	bool		showClusterStatistics;
	
	int		num_recursiventries;
	QStrList	recursivlabels,recursivfunctions;
	
	bool		translate_pov;
	

public:
	Preferences();
	~Preferences();

	void	save();

	int	numClusterHosts();
	QString	recentClusterHost(int);
        void	setClusterHost(QString);
	void 	deleteClusterHostList();
	void	setShowClusterStatistics(bool);
	bool	getShowClusterStatistics();
		

	void	setTexturePath(QString);
	QString	getTexturePath();
	void	setTempPath(QString);
	QString	getTempPath();
	void	setImagePath(QString);
	QString	getImagePath();
	void	setBumpMapPath(QString);
	QString	getBumpMapPath();
	void 	setAnimationPath(QString);
	QString getAnimationPath();
	void 	setDataPath(QString);
	QString	getDataPath();
	void 	setImageMapPath(QString);
	QString	getImageMapPath();
	void 	setFontPath(QString);
	QString	getFontPath();
	void 	setHeightfieldPath(QString);
	QString	getHeightfieldPath();

	void	setGridColor(QColor);
	QColor	getGridColor();
	void	setXAxisColor(QColor);
	QColor	getXAxisColor();
	void	setYAxisColor(QColor);
	QColor	getYAxisColor();
	void	setZAxisColor(QColor);
	QColor	getZAxisColor();
	void	setBackgroundColor(QColor);
	QColor	getBackgroundColor();
	void	setLinesColor(QColor);
	QColor	getLinesColor();
	void	setSelectedLinesColor(QColor);
	QColor	getSelectedLinesColor();
	void	setBlobColor(QColor);
	QColor	getBlobColor();
	void	setBoxColor(QColor);
	QColor	getBoxColor();

	void	setLetterXColor(QColor);
	QColor	getLetterXColor();
	void	setLetterYColor(QColor);
	QColor	getLetterYColor();
	void	setLetterZColor(QColor);
	QColor	getLetterZColor();


	bool	getDrawAxes();
	void	setDrawAxes(bool);


	QString getRenderProgram();
	void	setRenderProgram(QString);
	void	setRenderProgramParams(QString,QString,QString,int);
	QString getRenderProgramParam1();
	QString getRenderProgramParam2();
	QString getRenderProgramParam3();
	int	getActiveRenderProgramParam();
		

	QString getRenderSmallPreviewProgram();
	void	setRenderSmallPreviewProgram(QString);
	void	setRenderSmallPreviewProgramParams(QString,QString,QString,int);
	QString getRenderSmallPreviewProgramParam1();
	QString getRenderSmallPreviewProgramParam2();
	QString getRenderSmallPreviewProgramParam3();
	int	getActiveRenderSmallPreviewProgramParam();
	
	QString getRenderPreviewProgram();	
	void	setRenderPreviewProgram(QString);
	void	setRenderPreviewProgramParams(QString,QString,QString,int);
	QString getRenderPreviewProgramParam1();
	QString getRenderPreviewProgramParam2();
	QString getRenderPreviewProgramParam3();
	int	getActiveRenderPreviewProgramParam();
		
	
	void	setRenderPreview(int);
	int	getRenderPreview();
	void	setPreviewSize(int);
	int	getPreviewSize();

	void	setScreenSize(int,int);
	int	getScreenWidth();
	int	getScreenHeight();

	void	setResolution(int,int);
	int	getResolutionWidth();
	int	getResolutionHeight();

	double	getAspectRatio();

	void	setMainWindowSize(int,int);
	int	getMainWindowWidth();
	int	getMainWindowHeight();

	void	setAnimEditorSize(int,int);
	int	getAnimEditorWidth();
	int	getAnimEditorHeight();

	int	maxNumRecentFiles();
	void	setMaxNumRecentFiles(int);
	int	checkExistance();
	void	setCheckExistance(int);
	int	numRecentFiles();
	QString	recentFile(int n);


	void	setRecentFile(QString);
		
	void	setGridLinesXY(int);
	int	getGridLinesXY();
	void	setGridLinesXZ(int);
	int	getGridLinesXZ();
	void	setGridLinesZY(int);
	int	getGridLinesZY();
	void	setGridPointsXY(int);
	int	getGridPointsXY();
	void	setGridPointsXZ(int);
	int	getGridPointsXZ();
	void	setGridPointsZY(int);
	int	getGridPointsZY();

	QString	getDefaultTextureFile();

	void	setDefaultTextureFile(QString);
	void	setGridSpaceXY(double);
	double	getGridSpaceXY();
	void	setGridSpaceXZ(double);
	double	getGridSpaceXZ();
	void	setGridSpaceZY(double);
	double	getGridSpaceZY();
	void	setGridXY(bool);
	bool	getGridXY();
	void	setGridXZ(bool);
	bool	getGridXZ();
	void	setGridZY(bool);
	bool	getGridZY();

	void	setAutoSavePicture(bool);
	bool	getAutoSavePicture();

	int	getRecursivTreeNumEntries();
	QString	getRecursivTreeLabel(int);
	QString	getRecursivTreeFunction(int);
	void	setRecursivTree(QString,QString);
	void	deleteRecursivTree(QString);

	void	setTranslatePOV(bool);
	bool	getTranslatePOV();

	QString	getPath(QString);
	QString	povI18n(const char*);
};



#endif
