/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** image.h
*/
#ifndef __IMAGE_H__
#define __IMAGE_H__

#include <stdlib.h>
#include <stdio.h>
#include <qpainter.h>
#include <misc.h>
#include <kapp.h>
#include <qbuffer.h>
#include "preferences.h"
#include <qmessagebox.h>
#include <qwidget.h>
#include <qpixmap.h>
#include <qimage.h>
#include <qimageio.h>
#include <qframe.h>
#include <qstring.h>
#include <qlabel.h>



class Image : public QWidget
{
protected:
	QFrame	*preview;	
	QPixmap	pixmap;
	QImage	image,previewImage;
	QPixmap previewPixmap;
	QLabel	*imgWidth,*imgHeight,*imgDepth;
	QSize	qs;
	
	bool	previewOn,loaded;

	void paintEvent(QPaintEvent*);

public:
	Image(QWidget *p=0, bool preview=false);
	~Image();
	
	void	load(QString);
	void	update();

	char	*getImage(int *l,int w=0, int h=0);
	char 	*getExtension();


	QImage	getImage(int w=0, int h=0);

	void 	setImage(char *,int l);


	virtual QSize	sizeHint() const;

	int	getHeight();
	int	getWidth();
	int	getNumColors();

};



#endif
