/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** patternmodifier.h
*/
#ifndef __PATTERNMODIFER_H__
#define __PATTERNMODIFER_H__

#include <misc.h>
#include <list.h>
#include <chunk.h>
#include <stdio.h>
#include <string.h>

#include "texturebase.h"
#include "turbulence.h"
#include "transformations.h"

class patternmodifier:public textureBase
{


public:

	enum	ptyp 	
	{
		WRINKLES,
		AGATE, AVERAGE,BOXED,BOZO,BUMPS,
		CRACKLE,CYLINDRICAL, DENSITY,DENTS,
		GRADIENT, GRANITE,LEOPARD,  MANDEL,MARBLE,
		ONION,PLANAR,QUILTED,RADIAL,RIPPLES,SPHERICAL,
		SPIRAL1,SPIRAL2,WAVES,WOOD
	
	};

	patternmodifier(textureBase *p=NULL);	
	~patternmodifier();
	
	void 	setDensityInterpolation(bool);
	bool	getDensityInterpolation();

	void	setMode(int);
	int	getMode();

	char	*getDensityMap();
	void	setDensityMap(const char *);

	void	setAgateTurbulence(double);
	double	getAgateTurbulence();

	Vector3	getGradient();
	void 	setGradient(Vector3);
	
	int	getIterations();
	void	setIterations(int);

	double	getControl0();
	void	setControl0(double);

	double	getControl1();
	void	setControl1(double);

	double	getRadialFrequency();
	void	setRadialFrequency(double);

	double	getSpiral1Arms();
	void	setSpiral1Arms(double);

	double	getSpiral2Arms();
	void	setSpiral2Arms(double);

	bool	isEqual(textureBase *);
	bool	canAdd(textureBase *);
	void	add(textureBase *);

	int	save(media*);
	int	load(media*,int);

	int	exportPOV(FILE*,int,int, int,bool);

protected:

	ptyp	mode;

	double agate_turbulence;
	Vector3 gradient;
	int iterations;
	double control0, control1;
	double radial_frequency;
	double spiral1_arms,spiral2_arms;
	char *densitymap;
	int dinterpolate;
	
	void updateInfo();

};

#endif
