/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** media.cpp
*/



/*
indent -st media2.cpp -bad -bap -bl -bli0 -npcs -psl -di16 -i8 -ci4 -lp -l80 -nbc
*/


#include <stdlib.h>
#include <stdio.h>

#include "media.h"

media::media(FILE *fptr)
{
	array = 0;
	array_size = 0;
	data_size = 0;
	fp = fptr;
	if(fp)
	{
		pos = ftell(fp);
	}
	else
	{
		pos = 0;
	}
	close = 0;
}

media::media(const char *fn)
{
	array = 0;
	array_size = 0;
	data_size = 0;
	fp = fopen(fn,"wb");
	if(fp)
	{
		pos = ftell(fp);
		close = 1;
	}
	else
	{
		pos = 0;
		close = 0;
	}
}


media::~media()
{
	if(array)
		free(array);
	if(fp && close)
		fclose(fp);
}

int	media::eod()
{
	if(fp)
		return feof(fp);
		
	return (pos > data_size);
}

int	media::tell()
{
	if(fp)
		return ftell(fp);
		
	return pos;
}

int	media::seek(int dist,int how)
{
	if(fp)
		return fseek(fp,dist,how);

	pos = tell();
	switch(how)
	{
		case SEEK_SET:
			pos = MIN(MAX(dist,0),data_size);
		break;
		case SEEK_CUR:
			pos = MIN(MAX(pos + dist,0),data_size);
		break;
		case SEEK_END:
			pos = MIN(MAX(data_size - dist,0),data_size);
		break;
	}

	return pos;
}

int	media::read(void *buffer,int len)
{
	int	i;

	if(fp)
	{
		return fread(buffer,len,1,fp);
	}

	if(pos + len > data_size)
	{
		i = data_size - pos;
	}
	else
	{
		i = len;
	}

	if(i > 0)
		memcpy(buffer,(char*)array + pos,i);

	pos += i;

	return i;
}

int	media::write(const void *buffer,int len)
{
	if(fp)
	{
		return fwrite(buffer,len,1,fp);
	}

	if(pos + len > array_size)
	{
		void	*vp;

		vp = malloc(array_size + len + 1024);
		if(!vp)
			return -1;
		if(array)
		{
			memcpy(vp,array,array_size);
			free(array);
		}
		array = vp;
		array_size += len + 1024;
	}

	memcpy((char*)array + pos,buffer,len);
	data_size = MAX(data_size,pos + len);
	pos += len;

	return len;
}

const void	*media::data() const
{
	return array;
}

int		media::size()
{
	return data_size;
}


#ifdef TEST_MEDIA

void	main()
{
	FILE	*fp;

	fp = fopen("tmp.txt","wb");

	media	*mf = new media(fp);
	media	*mr = new media();

	mf->write("Hallo World",11);
	mr->write("Hallo World",11);

	mf->seek(6,SEEK_SET);
	mr->seek(6,SEEK_SET);

	mf->write("Tobias!",7);
	mr->write("Tobias!\0",8);

	printf("%s\n",mr->data());

	fclose(fp);

	delete mf;
	delete mr;

	return 0;
}

#endif


