/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** turbulencewidget.cpp
*/
#include "turbulencewidget.h"
#include "turbulencewidget.moc"



TurbulenceWidget::TurbulenceWidget(QWidget *p,Turbulence *t) :
	QDialog(p,"TurbulenceWidget",true)
{
        tr=t;

	turb=new VectorWidget(this,"Turbulence");
	turb->setVector(tr->getTurbulence());

	octaves=new SpinBox(this,"",tr->getOctaves() );
	oc=new QLabel("Octaves:",this);
        omega=new SpinBox(this,"",tr->getOmega() );
	om=new QLabel("Omega:",this);
	lambda=new SpinBox(this,"",tr->getLambda() );
	la=new QLabel("Lambda:",this);

	ok=new QPushButton("Okay",this);
	cancel=new QPushButton("Cancel",this);
	connect(ok,SIGNAL(clicked()),this,SLOT(OkPressed()));
	connect(cancel,SIGNAL(clicked()),this,SLOT(CancelPressed()));	

	resize(270,170);
	setMinimumSize(270,170);
	setMaximumSize(270,170);
}

int TurbulenceWidget::exec()
{
	return QDialog::exec();
}

void TurbulenceWidget::OkPressed()
{
	#ifdef DEBUG
	printf("Exiting TurbulenceWidget (accepting values)\n");
	#endif
	getTurbulence();

	QDialog::done(1);
}

void TurbulenceWidget::CancelPressed()
{
	#ifdef DEBUG
	printf("Exiting TRansformationWidget (REJECTING values)\n");
	#endif
	QDialog::done(0);
}

TurbulenceWidget::~TurbulenceWidget()
{
}

void TurbulenceWidget::getTurbulence()
{
	tr->setTurbulence(turb->getVector() );
	tr->setOmega(omega->getValue()  );	
	tr->setOctaves(octaves->getValue()  );	
	tr->setLambda(lambda->getValue()  );	
}

void TurbulenceWidget::paintEvent(QPaintEvent* qp)
{
	int w=width();
	int h=height();
	
	ok->setGeometry(w-120,h-27,40,25);
	cancel->setGeometry(w-75,h-27,70,25);

	turb->setGeometry(10,10,120,120);
	
	oc->setGeometry(140,10,60,25);
	octaves->setGeometry(205,10,60,25);

	om->setGeometry(140,40,60,25);
	omega->setGeometry(205,40,60,25);

	la->setGeometry(140,70,60,25);
	lambda->setGeometry(205,70,60,25);

	QDialog::paintEvent(qp);
}


