/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** texturewindow.cpp
*/


#include <version.h>

#include <kapp.h>
#include <klocale.h>
#include <kfiledialog.h>
#include <kstatusbar.h>

#define stloc(a)	(klocale->translate(a))

#include "texturewindow.h"
#include "texturewindow.moc"

#include "../editor/icons/toolbar/inserttexture.xpm"
#include "../editor/icons/toolbar/newtexture.xpm"
#include "../editor/icons/toolbar/newtexturewindow.xpm"
#include "../editor/icons/toolbar/savetexturelib.xpm"
#include "../editor/icons/toolbar/newtexturefolder.xpm"
#include "../editor/icons/toolbar/newpigment.xpm"
#include "../editor/icons/toolbar/newnormal.xpm"
#include "../editor/icons/toolbar/newfinish.xpm"
#include "../editor/icons/toolbar/newinterior.xpm"

TextureWindow::TextureWindow(char *name) :
//	KTopLevelWidget(name)
	KTMainWindow(name)
{
KFileDialog	*fd;
QString		qstr;
char		name[1024];

	tview=new TextureView(this,"");

	MPigment = new MPopupMenu;
	MPigment->insertItem("Pigment",tview,SLOT(newPigmentElementPig()),0);
	MPigment->insertSeparator();
	MPigment->insertItem("Color",tview,SLOT(newPigmentElementCol()),1);
	MPigment->insertItem("Image",tview,SLOT(newPigmentElementImg()),2);
	MPigment->insertItem("Colormap",tview,SLOT(newPigmentElementCma()),3);
	MPigment->insertItem("Colorlist",tview,SLOT(newPigmentElementCli()),4);
	//MPigment->insertItem("Pigmentlist"),tview,SLOT(newPigmentElementPli()),5);
	//MPigment->insertItem("Pigmentmap"),tview,SLOT(newPigmentElementPma()),6);

	MNormal = new MPopupMenu;
	MNormal->insertItem("Normal",tview,SLOT(newNormalElementNor()),0);
	MNormal->insertSeparator();
	MNormal->insertItem("Bumpmap",tview,SLOT(newNormalElementBmp()),1);
	MNormal->insertItem("Slopemap",tview,SLOT(newNormalElementSlp()),1);

	MFinish = new MPopupMenu;
	MFinish->insertItem("Finish-Parameter",tview,SLOT(newFinishElement()),0);


	MInterior = new MPopupMenu;
	MInterior->insertItem("Interior",tview,SLOT(newInteriorElementInt()),0);
	MInterior->insertSeparator();
	MInterior->insertItem("Density",tview,SLOT(newInteriorElementDen()),1);

	tbtxtview=new KToolBar(this);
	tbtxtview->insertButton(QPixmap((const char**)newtexturewindow_xpm),3,true,stloc("Open new Texture-Library-Window"));
	tbtxtview->insertSeparator();
	tbtxtview->insertButton(QPixmap((const char**)inserttexture_xpm),2,true,stloc("Insert Texture-Library"));
	tbtxtview->insertButton(QPixmap((const char**)savetexturelib_xpm),4,true,stloc("Save Texture-Library"));
	tbtxtview->insertSeparator();
	tbtxtview->insertButton(QPixmap((const char**)newtexture_xpm),5,true,stloc("New Texture"));
	tbtxtview->insertButton(QPixmap((const char**)newtexturefolder_xpm),1,true,stloc("New Texture-Folder"));
	tbtxtview->insertSeparator();
	tbtxtview->insertSeparator();
       	tbtxtview->insertButton(QPixmap((const char**)newpigment_xpm),6,MPigment,true,stloc("Edit/New Pigment/Pigmentobjects") );
	tbtxtview->insertButton(QPixmap((const char**)newnormal_xpm),7,MNormal,true,stloc("Edit/New Normal-Element"));
	tbtxtview->insertButton(QPixmap((const char**)newfinish_xpm),8,MFinish,true,stloc("Edit/New Finish"));
	tbtxtview->insertButton(QPixmap((const char**)newinterior_xpm),9,MInterior,true,stloc("Edit/New Interior"));
	addToolBar(tbtxtview);	

	

	setView(tview);

	connect(tbtxtview,SIGNAL(clicked(int)),tview,SLOT(MenuItemSel(int)));

	fd = new KFileDialog("Texturelibrary");
	fd->setCaption("Open Library");
	qstr = fd->getOpenFileName(prefs.getPath(prefs.getTexturePath()),"*.3dds",this,0);
	if(qstr == "") return;
	strcpy(name,qstr.data());
	delete fd;
	
	tview->loadLib(name);
}

TextureWindow::~TextureWindow()
{
	if (tview) delete tview;
}


void	TextureWindow::paintEvent(QPaintEvent *pe)
{
	
	//tview->setGeometry(0,0,width(),height() );
	KTMainWindow::paintEvent(pe);
//	KTopLevelWidget::paintEvent(pe);
}

void	TextureWindow::show()
{
	KTMainWindow::show();
//	KTopLevelWidget::show();
}
