/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** textureview.h
*/
#ifndef __TEXTUREVIEW_H__
#define __TEXTUREVIEW_H__


#include <qtabdialog.h>

#include "../widgets/treelist.h"
//#include "patternmodifierdialog.h"
#include "../../3d/textures/texture.h"
#include "../../3d/textures/texturelibrary.h"
#include "../../3d/textures/texturebook.h"
#include "../misc/renamedialog.h"
#include "../editor/drag3dds.h"
#include "colorwidget.h"
/*
#include "densitydialog.h"
#include "colorentrywidget.h"
#include "imagemapdialog.h"
#include "bumpmapdialog.h"
#include "colorlistdialog.h"
#include "colormapdialog.h"
#include "interiordialog.h"
#include "finishdialog.h"
*/
#include <qstring.h>
#include <qmessagebox.h>
#include <qpushbutton.h>
#include <qmenubar.h>
#include "../misc/preferences.h"
#include "../dialogs/dialogs.h"
#include "qtooltip.h"
/*
#include "pigmentdialog.h"
#include "normaldialog.h"
#include "finishdialog.h"
#include "interiordialog.h"
#include "texturedialog.h"
*/
#include <klocale.h>
#include <ktoolbar.h>
#include <qmenubar.h>
#include "../editor/mainwin.h"
#include <chunk.h>
#include <objects.h>

#include "texturewindow.h"



class TextureListView;

class	 TextureView: public  QWidget
{
Q_OBJECT
protected:

	int	nameColumn, infoColumn, activeColumn;	
	
	bool isCh;

	QMenuBar	*MenuBar;
	KToolBar	*ToolBar;

	QPopupMenu	*TextureNewPopup;
	//TreeListItem	*lastFolder,*lastItem;

	TextureLibrary	*tlib;

	TextureListView	*treelist;
	QPushButton	*newbook,*inslib,*savelib,*newlib;
	InfoDialog	*infod;
	Preferences	prefs;

	list <TextureView *> viewlist;

	virtual void 	paintEvent(QPaintEvent*);
	void insertLib();

	void saveLib();
public:

	TextureView(QWidget *p, char *name);
	~TextureView();


	void init();

public slots:

	void newPigmentElement(int );
	void newNormalElement(int );
	void newInteriorElement(int );
	void newFinishElement();

	void newPigmentElementPig();
	void newPigmentElementCol();
	void newPigmentElementImg();
	void newPigmentElementCma();
	void newPigmentElementCli();

	void newNormalElementNor();
	void newNormalElementBmp();
	void newNormalElementSlp();

	void newInteriorElementDen();
	void newInteriorElementInt();

      	void loadLib(char *);
	void MenuItemSel(int );

	void doubleClicked(QListViewItem *);
	void selChanged(QListViewItem *);
	void popupClicked(QListViewItem *,int,int);	
	void rightButtonClicked(QListViewItem *,const QPoint &,int);

	void StandardPopupSel(int);
	void NewPigmentSel(int);
	void NewTextureItemSel(int);
	void NewTextureBookSel(int);
	void NewNormalSel(int);
	void NewSlopeMapSel(int);
	void NewFinishSel(int);
	void NewPigmentListSel(int);
	void NewPigmentMapSel(int);
	void NormalMapSel(int);
	void NormalListSel(int);
	void NewColorMapSel(int);
	void NewColorListSel(int);
	void NewInteriorSel(int);
	void NewDensitySel(int);

	void addSubItems(TreeListItem *,textureBase *);
	void addItem(TreeListItem *,textureBase *);
	void addItem(TreeList *,textureBase *);

	void updateItem(TreeListItem *);
	void updateAll();

	void exportTLib();

	void setWorld(world *);

	void CloseView(TextureView *);

signals:
	void colorItemSelected( color *);
	void changedTexture(texture *);
	void viewClosed(TextureView *);
	void message(QString);

};

class 	TextureListView: public TreeList
{
Q_OBJECT
public:
	TextureListView(QWidget *p, char *name);
	~TextureListView();	
	void 	setLib(TextureLibrary *);
protected:
        TextureView *tview;
	QPopupMenu	*DnDPopup;
	TextureLibrary *tlib;



	virtual void	dragEnterEvent(QDragEnterEvent *de);
	virtual void	dragLeaveEvent(QDragLeaveEvent *de);
	virtual void	dragMoveEvent(QDragMoveEvent *de);
	virtual void	dropEvent(QDropEvent *de);

	virtual void	startDragCopy(QListViewItem *item,QWidget *dragsource);
	virtual void	startDragMove(QListViewItem *item,QWidget *dragsource);

};

#endif
