/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** textureview.cpp
*/
#include "textureview.h"
#include "textureview.moc"
#include "patternmodifierdialog.h"
#include "densitydialog.h"
#include "colorentrywidget.h"
#include "imagemapdialog.h"
#include "bumpmapdialog.h"
#include "colorlistdialog.h"
#include "colormapdialog.h"
#include "interiordialog.h"
#include "finishdialog.h"
#include "pigmentdialog.h"
#include "normaldialog.h"
#include "finishdialog.h"
#include "interiordialog.h"
#include "texturedialog.h"
#include "slopemapdialog.h"
const char *hakenPic[] = {
"15 13 3 1",
" 	c None",
".	c #FFFFFF",
"+	c #000000",
"...............",
"............+..",
"...........+...",
"..........+....",
".........+.....",
".........+.....",
"........+......",
"..+.....+......",
"...+....+......",
"....+..+.......",
".....+.+.......",
"......+........",
"..............."};


//#define stloc(a)	((char*)locale->translate((a)))
#define stloc(a) (a)

TextureView::TextureView(QWidget *p,char *name) :
	QWidget(p,name)
{
	isCh=true;
	tlib=new TextureLibrary();
	init();

}

void TextureView::loadLib(char *fname)
{
FILE *fp;
media *m;
textureBase *tb;
QString qstr;

	isCh=false;
	if (tlib) delete tlib;
	tlib=new TextureLibrary();
	treelist->setLib(tlib);

	fp=fopen(fname,"r");
	if (fp) {
		m=new media( fp);
		if (m) {
			tlib->setName(qstr);
			tlib->load(m);
			delete m;
		}
		fclose(fp);
	}
	treelist->clear();  // Treelist leeren
	
	tb=tlib->getFirstElement();
	while (tb!=NULL)
       	{
		if (tb) addItem( treelist ,(TextureBook *)tb);

       		tb=tlib->getNextElement();
       }
}

void TextureView::init()
{
	treelist=new TextureListView(this,"Texturelistview");
	treelist->setMultiSelection(false);
	treelist->setLib(tlib);

	nameColumn=treelist->addColumn("Name");
	activeColumn=treelist->addColumn("active");
	infoColumn=treelist->addColumn("Info");	


	if (isCh==false){
		setWFlags(WStyle_NormalBorder|WStyle_Title);
		newlib=NULL;
	}

	
	connect (treelist,SIGNAL(doubleClicked(QListViewItem *)),this,SLOT(doubleClicked(QListViewItem *)) );
	connect (treelist,SIGNAL(currentChanged(QListViewItem *)),this,SLOT(selChanged(QListViewItem *)) );
	connect (treelist,SIGNAL(popupMenu(QListViewItem *,int,int)),this,SLOT(popupClicked(QListViewItem *,int,int)) );
	connect (treelist,SIGNAL(rightButtonPressed(QListViewItem *,const QPoint &,int)),this,SLOT(rightButtonClicked(QListViewItem *,const QPoint &,int)) );
}

void TextureView::rightButtonClicked(QListViewItem *qli,const QPoint & qp,int c)
{
	
	printf("#########\n");
}

void TextureView::newNormalElementBmp()
{
	newNormalElement(1);
}

void TextureView::newNormalElementSlp()
{
	newNormalElement(2);
}


void TextureView::newNormalElementNor()
{
	newNormalElement(0);
}


void TextureView::newInteriorElementDen()
{
	newInteriorElement(1);
}

void TextureView::newInteriorElementInt()
{
	newInteriorElement(0);
}


void TextureView::newPigmentElementPig()
{
	newPigmentElement(0);
}

void TextureView::newPigmentElementCol()
{
	newPigmentElement(1);
}
void TextureView::newPigmentElementImg()
{
	newPigmentElement(2);
}
void TextureView::newPigmentElementCma()
{
	newPigmentElement(3);
}
void TextureView::newPigmentElementCli()
{
	newPigmentElement(4);
}

void TextureView::newNormalElement(int t)
{
textureBase *tb,*ttb;
TreeListItem *tli=(TreeListItem *)treelist->currentItem();
	if (tli) tb=(textureBase *)tli->getData();
	else tb=tlib;

	switch(t)
	{
		case 0:
			if ( (ttb=tb->getElementByType(NORMAL))==NULL) {
				normal *c=new normal(tb);
				if (tb->canAdd(c)) {
					NormalDialog *cd=new NormalDialog(NULL,c);
					cd->exec();
					tb->add(c);
					c->setSelected(true);
					updateAll();
				}else delete c;
			} else {
				NormalDialog *cd=new NormalDialog(NULL,(normal *)ttb);
				cd->exec();
			}

		break;
		case 1:
		{
			if ( (ttb=tb->getElementByType(BUMPMAP))==NULL) {
				bumpMap *c=new bumpMap(tb);
				if (tb->canAdd(c)) {
					BumpMapDialog *cd=new BumpMapDialog(NULL,c);
					cd->exec();
					tb->add(c);
					c->setSelected(true);
					updateAll();
				}else delete c;
			} else {
				BumpMapDialog *cd=new BumpMapDialog(NULL,(bumpMap *)ttb);
				cd->exec();
			}
		}
		break;
		case 2:
		{
			if ( (ttb=tb->getElementByType(SLOPEMAP))==NULL) {
				slopeMap *c=new slopeMap(tb);
				if (tb->canAdd(c)) {
					SlopeMapDialog *cd=new SlopeMapDialog(NULL,c);
					cd->exec();
					tb->add(c);
					c->setSelected(true);
					updateAll();
				}else delete c;
			} else {
				SlopeMapDialog *cd=new SlopeMapDialog(NULL,(slopeMap *)ttb);
				cd->exec();
			}
		}
		break;
		default:
		break;
	}
}

void TextureView::newInteriorElement(int t)
{
textureBase *tb,*ttb;
TreeListItem *tli=(TreeListItem *)treelist->currentItem();
	if (tli) tb=(textureBase *)tli->getData();
	else tb=tlib;

	switch(t) {
		case 0:
		{
			if ( (ttb=tb->getElementByType(INTERIOR))==NULL) {
				interior *c=new interior(tb);
				if (tb->canAdd(c)) {
					InteriorDialog *cd=new InteriorDialog(NULL,c);
					cd->exec();
					tb->add(c);
					c->setSelected(true);
					updateAll();
				}else delete c;
			} else {
				InteriorDialog *cd=new InteriorDialog(NULL,(interior *)ttb);
				cd->exec();
			}

		}
		break;
		case 1:
		{
			if ( (ttb=tb->getElementByType(DENSITY))==NULL) {
				Density *c=new Density(tb);
				if (tb->canAdd(c)) {
					DensityDialog *cd=new DensityDialog(NULL,c);
					cd->exec();
					tb->add(c);
					c->setSelected(true);
					updateAll();
				}else delete c;
			} else {
				DensityDialog *cd=new DensityDialog(NULL,(Density *)ttb);
				cd->exec();
			}
		}
		break;
		default:
		break;
	}
}

void TextureView::newFinishElement()
{
textureBase *tb,*ttb;
TreeListItem *tli=(TreeListItem *)treelist->currentItem();
	if (tli) tb=(textureBase *)tli->getData();
	else tb=tlib;

	if ( (ttb=tb->getElementByType(FINISH))==NULL) {
		finish *c=new finish(NULL);
		if (tb->canAdd(c)) {
			FinishDialog *cd=new FinishDialog(NULL,c);
			cd->exec();
			tb->add(c);
			c->setSelected(true);
			updateAll();
		} else delete c;
	} else {
		FinishDialog *cd=new FinishDialog(NULL,(finish *)ttb);
		cd->exec();
	}
}


void TextureView::newPigmentElement(int t)
{
textureBase *tb,*ttb;
TreeListItem *tli=(TreeListItem *)treelist->currentItem();
	if (tli) tb=(textureBase *)tli->getData();
	else tb=tlib;
	switch(t)
	{
		case 0:
		{
			if ( (ttb=tb->getElementByType(PIGMENT))==NULL) {
				pigment *c=new pigment(NULL);
				if (tb->canAdd(c)) {
					PigmentDialog *cd=new PigmentDialog(NULL,c);
					cd->exec();
					tb->add(c);
					c->setSelected(true);
					updateAll();
				} else delete c;
			} else {
				PigmentDialog *cd=new PigmentDialog(NULL,(pigment *)ttb);
				cd->exec();
			}
		}
		break;
		case 1:
		{
			if ( (ttb=tb->getElementByType(COLOR))==NULL) {
				color *c=new color(NULL);
				if (tb->canAdd(c)) {
					ColorDialog *cd=new ColorDialog(NULL,c);
					cd->exec();
					tb->add(c);
					c->setSelected(true);
					updateAll();
				} else delete c;
			} else {
				ColorDialog *cd=new ColorDialog(NULL,(color *)ttb);
				cd->exec();
			}
		}
		break;
		case 2:
		{
			if ( (ttb=tb->getElementByType(IMAGEMAP))==NULL) {
				imageMap *c=new imageMap(tb);
				if (tb->canAdd(c)) {
					ImageMapDialog *cd=new ImageMapDialog(NULL,c);
					cd->exec();
					tb->add(c);
					c->setSelected(true);
					updateAll();
				} else delete c;
			} else {
				ImageMapDialog *cd=new ImageMapDialog(NULL,(imageMap *)ttb);
				cd->exec();
			}
		}
		break;
		case 3:
		{
			if ( (ttb=tb->getElementByType(COLORMAP))==NULL) {
				colorMap *c=new colorMap(tb);
				if (tb->canAdd(c)) {
					ColorMapDialog *cd=new ColorMapDialog(NULL,c);
					cd->exec();
					tb->add(c);
					c->setSelected(true);
					updateAll();
				} else delete c;
			} else {
				ColorMapDialog *cd=new ColorMapDialog(NULL,(colorMap *)ttb);
				cd->exec();
			}
		}
		break;
		case 4:
		{
			if ( (ttb=tb->getElementByType(COLORLIST))==NULL) {
				colorList *c=new colorList(tb);
				if (tb->canAdd(c)) {
					ColorListDialog *cd=new ColorListDialog(NULL,c);
					cd->exec();
					tb->add(c);
					c->setSelected(true);
					updateAll();
				} else delete c;
			} else {
				ColorListDialog *cd=new ColorListDialog(NULL,(colorList *)ttb);
				cd->exec();
			}
		}
		break;
		default:
		break;
	}
}

void TextureView::MenuItemSel(int i)
{
TextureWindow *tw;
textureBase *tb;
TreeListItem *tli=(TreeListItem *)treelist->currentItem();

	if (tli) tb=(textureBase *)tli->getData();
	else tb=tlib;
	switch(i) {
		case 1:
		{
			tb->addElement( new TextureBook(tb),NULL );
			updateAll();
		}
		break;
		case 2:
			insertLib();
		break;
		case 3:
			tw=new TextureWindow("Texture");
			tw->show();
		break;
		case 4:
			saveLib();
		break;
		case 5: //new Texture
		{
			texture *t= new texture(tb);
			tb->add(t);
			if (tb==tlib) addItem(treelist,t);
			else addItem (tli,t);
		}		
		break;
		default:
		break;
	}


}

void TextureView::updateAll()
{
textureBase *tb=tlib->getFirstElement(),*tb2;
TreeListItem *tli=(TreeListItem*)treelist->currentItem();

   	if (tli) {
		tb2=(textureBase *)(tli->getData());
		if (tb2) tb2->setSelected(false);
	}

	treelist->clear();  // Treelist leeren
	while (tb!=NULL)
       	{
		if (tb) addItem( treelist ,(TextureBook *)tb);
       		tb=tlib->getNextElement();
       	}
	

}

TextureView::~TextureView()
{
#ifdef DEBUG
	printf("Closing View");
#endif
}

void TextureView::CloseView(TextureView *tw)
{
int x;
	x=viewlist.find(tw);
	if (x>-1) viewlist.deleteAt(x);

}

void TextureView::exportTLib() //export as POV
{
	KFileDialog	*fd;
	QString		qstr;
	char		name[1024];
	FILE		*fp;
	
	fd = new KFileDialog("Export POV");
	fd->setCaption("Export POV");
	qstr = fd->getSaveFileName("","*.pov",this,0);
	if(qstr == "") { delete fd; return; }
	strcpy(name,qstr.data());
	delete fd;

	fp=fopen( (const char *)name,"w+");
	if (fp) {
		tlib->exportPOV(fp,0,5,0,true);
		fclose(fp);
	}
}


void TextureView::saveLib()
{
	KFileDialog	*fd;
	QString		qstr;
	char		name[1024];
	media		*m;
	
	fd = new KFileDialog("Save Library");
	fd->setCaption("Save Library");
	qstr = fd->getSaveFileName(prefs.getPath(prefs.getTexturePath()),"*.3dds",this,0);
	if(qstr == "") { delete fd; return; }
	strcpy(name,qstr.data());
	delete fd;

	m=new media( (const char *)name);
	if (m) {
		tlib->setName(qstr);
		tlib->saveLib(m);
		delete m;
	}
}

void TextureView::insertLib()
{
	textureBase	*tb;
	KFileDialog	*fd;
	QString		qstr;
	char		name[1024];
	media		*m;
	FILE		*fp;
	
	fd = new KFileDialog("Insert Library");
	fd->setCaption("Insert Library");
	qstr = fd->getOpenFileName(prefs.getPath(prefs.getTexturePath()),"*.3dds",this,0);
	if(qstr == "") return;
	strcpy(name,qstr.data());
	delete fd;

	fp=fopen(name,"r");
	if (fp) {
		m=new media( fp);
		if (m) {
			tlib->setName(qstr);
			tlib->load(m);
			delete m;
		}
		fclose(fp);
	}
	treelist->clear();  // Treelist leeren
	
	tb=tlib->getFirstElement();
	while (tb!=NULL)
       	{
		if (tb) addItem( treelist,(TextureBook *)tb);
       		tb=tlib->getNextElement();
       }
}

void TextureView::setWorld(world *w)
{

textureBase	*tb;

#ifdef DEBUG
	printf("setWorldcalled\n");
#endif
	tlib=w->getTextureLibrary();
	treelist->setLib(tlib);
	treelist->clear();  // Treelist leeren
	
	tb=tlib->getFirstElement();
	while (tb!=NULL)
       	{
		if (tb) addItem( treelist ,(TextureBook *)tb);

       		tb=tlib->getNextElement();
       }
}

void TextureView::addSubItems(TreeListItem *tli, textureBase *t)
{
TreeListItem *tmp;
textureBase *tb;

	if (t==NULL) return;
	tb=t->getFirstElement();

	while (tb!=NULL) {

		tmp=new TreeListItem(tli,tb->getName(),18);
		tmp->setPixmap(nameColumn,*new QPixmap(  tb->getXPM() ));
		tmp->setText(infoColumn,tb->getInfo() );
		tmp->setExpandable(tb->hasSubItems() );
		if (tb->active()==true) tmp->setPixmap(activeColumn,*new QPixmap(hakenPic));
		else tmp->setPixmap(activeColumn,*new QPixmap());
		tmp->setData(tb);	
		tmp->setPixmap(nameColumn,*new QPixmap(tb->getXPM()));
		tmp->setOpen( tb->isOpen() );

		if (tb->isSelected()) treelist->setCurrentItem(tmp);

		if (tb->hasSubItems()==true) addSubItems(tmp,tb);
		tb=t->getNextElement();
        }

}

void TextureView::addItem(TreeListItem *tli, textureBase *t)
{
TreeListItem *tmp;

	if (t==NULL) return;
	tmp=new TreeListItem(tli,t->getName(),18);
	tmp->setText(infoColumn,t->getInfo());

	tmp->setExpandable(t->hasSubItems() );
	if (t->active()==true) tli->setPixmap(activeColumn,*new QPixmap(hakenPic));
	else tli->setPixmap(activeColumn,*new QPixmap());

	if (t->isSelected()) treelist->setCurrentItem(tli);

	tmp->setData(t);	
	tmp->setPixmap(nameColumn,*new QPixmap(t->getXPM()));
	tmp->setOpen( t->isOpen() );




	if (t->hasSubItems()==true) addSubItems(tmp,t);
}

void TextureView::addItem(TreeList *tl, textureBase *t)
{
TreeListItem *tmp;
textureBase *tb;

	if (t==NULL) return;
	tmp=new TreeListItem(tl,t->getName(),18);
	tmp->setText(infoColumn,t->getInfo());
	tmp->setExpandable(t->hasSubItems() );
	if (t->active()==true) tmp->setPixmap(activeColumn,*new QPixmap(hakenPic));
	else tmp->setPixmap(activeColumn,*new QPixmap());
	tmp->setData(t);	
	tmp->setPixmap(nameColumn,*new QPixmap(t->getXPM()));
	tmp->setOpen( t->isOpen() );

	if (t->isSelected()) treelist->setCurrentItem(tmp);

	tb=t->getFirstElement();
	while (tb!=NULL) {
		addItem(tmp,tb );
		tb=t->getNextElement();
	}
}


void TextureView::updateItem(TreeListItem *tli)
{
textureBase *tb;
	
	if (!tli) return;
	tb=(textureBase *)tli->getData();
	if (!tb) return;

	tli->setText(infoColumn,tb->getInfo());
	tli->setPixmap(nameColumn,*new QPixmap(tb->getXPM()));
	tli->setExpandable(tb->hasSubItems() );
	tli->setOpen( tb->isOpen() );
	if (tb->active()==true) tli->setPixmap(activeColumn,*new QPixmap(hakenPic));
	else tli->setPixmap(activeColumn,*new QPixmap());

	if (tb->isSelected()) treelist->setCurrentItem(tli);

	tli->setData(tb);	

	if (tli->childCount()>0) {
		TreeListItem *a=(TreeListItem *)tli->firstChild();
		while (a!=NULL) {
			tli->removeItem(a);
			a=(TreeListItem *)tli->firstChild();
		}

	}

	if (tb->hasSubItems()==true) {
		//tli->setOpen(true);
		addSubItems(tli,tb);
	}
}

void TextureView::StandardPopupSel(int x)
{
TreeListItem *lastItem=(TreeListItem*)treelist->currentItem();
textureBase *tb=lastItem->getData();
QString qs;
char *txt;
pigment *pi;
PigmentDialog *pmd;
NormalDialog *nmd;
normal *no;
texture *t,*te;
TextureDialog *td;
TextureBook *tbook;
finish *fi;
interior *inter;
InteriorDialog *interd;
FinishDialog *fd;


	if (x==2) { // Rename
		RenameDialog *rn=new RenameDialog(NULL,(char *)tb->getName() );
		txt=strdup(rn->exec());
		delete rn;
		if (txt!=NULL) {
			tb->setName(txt);	
			lastItem->setText(nameColumn,tb->getName() );
			if (tb->getType()==TEXTURE) {		
				emit changedTexture( (texture *)tb);
			}
		}
		return;
	
	}
	if (x==3) { // active
		TreeListItem *t1=(TreeListItem*)lastItem->parent();
		textureBase *t2=(textureBase *)t1->getData();

		t2->setActive( !tb->active(),tb );
		updateItem((TreeListItem *)(lastItem->parent()) );
		return;
	}

	if (x==13) { // Delete
		TreeListItem *p=(TreeListItem *)(lastItem->parent());

		if (QMessageBox::warning(this,
		"K4DE - Delete item ?",
		"Are you sure, that you want to delete this item ?",
		"&Yes","&No","Cancel",1,2) ==0) {
			if (p!=NULL) {
				textureBase *t=p->getData();
				t->remove(tb);
				updateItem(p);
				return;
			} else {
				TreeListItem *p=(TreeListItem *)lastItem;
				TextureLibrary *t=(TextureLibrary *)p->getData();	
				t->remove(tb);
				delete p;
			}
		}
	}

	switch(tb->getType())
	{
		case TURBULENCEMODIFIER:
			switch(x) {
				case 20: //Properties
				{
					Turbulence *tu=(Turbulence*)tb;
					TurbulenceWidget *td=new TurbulenceWidget(NULL,tu);
					td->exec();
					updateItem(lastItem);
				}
				break;
			}
		break;
		case TRANSFORMATIONS:
			switch(x) {
				case 20: //Properties
				{
					Transformations *tr=(Transformations*)tb;
					TransformationsWidget *td=new TransformationsWidget(NULL,tr);
					td->exec();
					updateItem(lastItem);
				}
				break;
			}
		break;
		case COLOR:
			switch(x) {
				case 20: //Properties
				{
					color *c=(color*)tb;
					ColorDialog *cd=new ColorDialog(NULL,c);
					cd->exec();
					updateItem(lastItem);
				}
				break;
			}
		break;
		case COLORENTRY:
			switch(x) {
				case 20: //Properties
				{
					colorEntry *c=(colorEntry*)tb;
					ColorEntryDialog *cd=new ColorEntryDialog(NULL,c);
					colorMap *cm=(colorMap*)c->getParent();

					cd->exec();
					cm->sortColorMap();				
					updateItem( (TreeListItem *)lastItem->parent());
				}
				break;
			}
		break;
		case COLORLIST:
			switch(x) {			
				case 20: //Properties
				{
					colorList *cl=(colorList*)tb;
					ColorListDialog *cld=new ColorListDialog(NULL,cl);
					cld->exec();
					updateItem(lastItem);
				}
				break;
				case 40: //new Color
				{
					tb->addElement( new color(tb),NULL);
					updateItem(lastItem);
				}
				break;
			}
		break;
		case COLORMAP:
			switch(x) {			
				case 20: //Properties
				{
					colorMap *cm=(colorMap*)tb;
					ColorMapDialog *cmd=new ColorMapDialog(NULL,cm);
					cmd->exec();
					updateItem(lastItem);
				}
				break;
				case 40: //new Entry
				colorEntry *co=new colorEntry(tb);
				{
					tb->addElement( co,NULL);
					co->setActive(true);
					
					updateItem(lastItem);
				}
				break;
			}
		break;

		case IMAGEMAP:
			switch(x) {

			
				case 20: //Properties
				{
					imageMap *im=(imageMap*)tb;
					ImageMapDialog *imd=new ImageMapDialog(NULL,im);
					imd->exec();
					updateItem(lastItem);
				}
				break;
			}
		break;
		case PIGMENT:
			switch(x) {
				case 1: // new
				break;
				case 20: //Properties
					pi=(pigment *)tb;
					pmd=new PigmentDialog(NULL,pi);
					pmd->exec();
      					lastItem->setText(0,pi->getName());
					lastItem->setText(infoColumn,tb->getInfo());
					updateItem(lastItem);
				break;
			}
		break;
		case NORMAL:
			switch(x) {
				case 20: //Properties
					no=(normal *)tb;
					nmd=new NormalDialog(NULL,no);
					nmd->exec();
      					lastItem->setText(0,no->getName());
					lastItem->setText(infoColumn,no->getInfo());
				break;
			}
		break;
		case SLOPEMAP:
			switch(x) {			
				case 20: //Properties
				{
					slopeMap *cm=(slopeMap*)tb;
					SlopeMapDialog *cmd=new SlopeMapDialog(NULL,cm);
					cmd->exec();
					updateItem(lastItem);
				}
				break;
				case 40: //new Entry
				slopeEntry *co=new slopeEntry(tb);
				{
					tb->addElement( co,NULL);
					co->setActive(true);
					
					updateItem(lastItem);
				}
				break;
			}
		break;
		case SLOPEENTRY:
			switch(x) {			
				case 20: //Properties
				{
					slopeEntry *cm=(slopeEntry*)tb;
					SlopeEntryDialog *cmd=new SlopeEntryDialog(NULL,cm);
					cmd->exec();
					updateItem(lastItem);
				}
				break;
	
			}
		break;
		case FINISH:
			switch(x) {
				case 1: // new
				break;
				case 20: //Properties
					fi=(finish *)tb;
					fd=new FinishDialog(NULL,fi);
					fd->exec();
      					lastItem->setText(0,fi->getName());
					lastItem->setText(infoColumn,fi->getInfo());
				break;
			}
		break;
		case INTERIOR:
			switch(x) {
				case 20: //Properties
					inter=(interior *)tb;
					interd=new InteriorDialog(NULL,inter);
					interd->exec();
      					lastItem->setText(0,inter->getName());
					lastItem->setText(infoColumn,inter->getInfo());
					updateItem(lastItem);
				break;
			}
		break;
		case DENSITY:
			switch(x) {
				case 20: //Properties
				{
					Density *de=(Density *)tb;
					DensityDialog *dd=new DensityDialog(NULL,de);
					dd->exec();
					updateItem(lastItem);
				}
				break;
			}
		break;
		case BUMPMAP:
			switch(x) {

				case 20: //Properties
				{
					bumpMap *bu=(bumpMap *)tb;
					BumpMapDialog *bmd=new BumpMapDialog(NULL,bu);
        				bmd->exec();
					lastItem->setText(0,(const char *)bu->getName());
					lastItem->setText(infoColumn,(const char *)bu->getInfo());
					updateItem(lastItem);
					delete bmd;
                                }
				break;
			}
		break;
		case TEXTUREBOOK:

		break;
		case TEXTURE:
			switch(x) {
				case 1: // new
					tbook=(TextureBook *)tb;
					t=new texture(tb);
					tbook->add(t);
        				addItem(lastItem,t);

				break;
				case 20: //Properties
					te=(texture *)tb;

					td=new TextureDialog(NULL,te);
					td->exec();
      					lastItem->setText(0,te->getName());
					lastItem->setText(infoColumn,te->getInfo());
					updateItem(lastItem);

				break;
			}
		break;
		default:
		break;
	}

	if (x==20) {  //Texture changed !
		while (tb!=NULL) {
			if (tb->getType()==TEXTURE) {		
				emit changedTexture( (texture *)tb);
				tb=NULL;
			} else tb=tb->getParent();
		}
	}

}

void TextureView::NewTextureBookSel(int t)
{
TreeListItem *lastItem=(TreeListItem*)treelist->currentItem();
textureBase *tb=lastItem->getData();
textureBase *tbook,*tbook2,*tx;	
	lastItem->setOpen(true);
	switch(t) {
		case 30://new texture
			tb->add ( (tx=(textureBase*)new texture(tb)) );
			addItem(lastItem, tx);
		break;
		case 31://new book
		    	tbook=(TextureBook *)tb;
			tbook->add ( (tbook2=new TextureBook(tb)) );
			addItem(lastItem, (textureBase *)tbook2);
		break;
	}
}



void TextureView::popupClicked(QListViewItem *qli,int x, int y)
{
TreeListItem *tli=(TreeListItem *)qli;
textureBase *tb=tli->getData();

QPopupMenu	*StandardPopup,*NewPigmentPopup;
QPopupMenu	*TextureBookPopup,*NewNormalPopup;	
QPopupMenu	*FinishNewPopup;
QPopupMenu	*PigmentListNewPopup,*PigmentMapNewPopup;
QPopupMenu	*NormalListNewPopup,*NormalMapNewPopup;
QPopupMenu	*SlopeMapNewPopup;
QPopupMenu	*ColorListNewPopup,*ColorMapNewPopup;
QPopupMenu	*DensityNewPopup,*InteriorNewPopup;



	FinishNewPopup=NULL;
	PigmentListNewPopup=NULL;
	PigmentMapNewPopup=NULL;
	NormalListNewPopup=NULL;
	NormalMapNewPopup=NULL;
	ColorListNewPopup=NULL;
	ColorMapNewPopup=NULL;
	DensityNewPopup=NULL;
	NewPigmentPopup=NULL;
	StandardPopup=NULL;
	TextureNewPopup=NULL;
	TextureBookPopup=NULL;
	NewNormalPopup=NULL;
	InteriorNewPopup=NULL;
	SlopeMapNewPopup=NULL;

	if (tb==NULL) return;

	StandardPopup=new QPopupMenu(NULL);
	StandardPopup->setCheckable(true);

	switch (tb->getType()) {
		case FINISH:
			//FinishNewPopup=new QPopupMenu(NULL);
			//FinishNewPopup->insertItem("Transformations",10);
			//FinishNewPopup->insertItem("Turbulence",11);
			//StandardPopup->insertItem("New",FinishNewPopup);
			//connect(FinishNewPopup,SIGNAL(activated(int)),this,SLOT(NewFinishSel(int)) );	
		break;
		case SLOPEMAP:
		break;
			SlopeMapNewPopup=new QPopupMenu(NULL);
			SlopeMapNewPopup->insertItem("Entry",1);
			StandardPopup->insertItem("New",SlopeMapNewPopup);
			connect(SlopeMapNewPopup,SIGNAL(activated(int)),this,SLOT(NewSlopeMapSel(int)) );	
		case PIGMENTMAP:
			PigmentMapNewPopup=new QPopupMenu(NULL);
			PigmentMapNewPopup->insertItem("Entry",1);
			PigmentMapNewPopup->insertSeparator();
			PigmentMapNewPopup->insertItem("Transformations",10);
			PigmentMapNewPopup->insertItem("Turbulence",11);
			StandardPopup->insertItem("New",PigmentMapNewPopup);
			connect(PigmentMapNewPopup,SIGNAL(activated(int)),this,SLOT(NewPigmentMapSel(int)) );	
		break;		
		case PIGMENTLIST:
			PigmentListNewPopup=new QPopupMenu(NULL);
			PigmentListNewPopup->insertItem("Pigment",1);
			PigmentListNewPopup->insertSeparator();
			PigmentListNewPopup->insertItem("Transformations",10);
			PigmentListNewPopup->insertItem("Turbulence",11);
			StandardPopup->insertItem("New",PigmentListNewPopup);
			connect(PigmentListNewPopup,SIGNAL(activated(int)),this,SLOT(NewPigmentListSel(int)) );	
		break;
		case NORMALMAP:
			NormalMapNewPopup=new QPopupMenu(NULL);
			NormalMapNewPopup->insertItem("Entry",1);
			NormalMapNewPopup->insertSeparator();
			NormalMapNewPopup->insertItem("Transformations",10);
			NormalMapNewPopup->insertItem("Turbulence",11);
			StandardPopup->insertItem("New",NormalMapNewPopup);
			connect(NormalMapNewPopup,SIGNAL(activated(int)),this,SLOT(NewNormalMapSel(int)) );	
		break;		
		case NORMALLIST:
			NormalListNewPopup=new QPopupMenu(NULL);
			NormalListNewPopup->insertItem("Normal",1);			
			NormalListNewPopup->insertSeparator();
			NormalListNewPopup->insertItem("Transformations",10);
			NormalListNewPopup->insertItem("Turbulence",11);
			StandardPopup->insertItem("New",NormalListNewPopup);
			connect(NormalListNewPopup,SIGNAL(activated(int)),this,SLOT(NewNormalListSel(int)) );	
		break;
		case COLORLIST:
			ColorListNewPopup=new QPopupMenu(NULL);
			ColorListNewPopup->insertItem("Color",1);
			//ColorListNewPopup->insertSeparator();
			//ColorListNewPopup->insertItem("Transformations",10);
			//ColorListNewPopup->insertItem("Turbulence",11);			
			StandardPopup->insertItem("New",ColorListNewPopup);
			connect(ColorListNewPopup,SIGNAL(activated(int)),this,SLOT(NewColorListSel(int)) );	
		break;
		case COLORMAP:
			ColorMapNewPopup=new QPopupMenu(NULL);
			ColorMapNewPopup->insertItem("Entry",1);
			//ColorMapNewPopup->insertSeparator();
			//ColorMapNewPopup->insertItem("Transformations",10);
			//ColorMapNewPopup->insertItem("Turbulence",11);			
			StandardPopup->insertItem("New",ColorMapNewPopup);
			connect(ColorMapNewPopup,SIGNAL(activated(int)),this,SLOT(NewColorMapSel(int)) );	
		break;
		case INTERIOR:
			InteriorNewPopup=new QPopupMenu(NULL);
			InteriorNewPopup->insertItem("Density",1);
			//InteriorNewPopup->insertSeparator();
			//InteriorNewPopup->insertItem("Transformations",10);
			//InteriorNewPopup->insertItem("Turbulence",11);			
			StandardPopup->insertItem("New",InteriorNewPopup);
			connect(InteriorNewPopup,SIGNAL(activated(int)),this,SLOT(NewInteriorSel(int)) );	
		break;
		case DENSITY:
			DensityNewPopup=new QPopupMenu(NULL);
			DensityNewPopup->insertItem("Entry",1);
			DensityNewPopup->insertSeparator();
			DensityNewPopup->insertItem("Transformations",10);
			DensityNewPopup->insertItem("Turbulence",11);	
			StandardPopup->insertItem("New",DensityNewPopup);

			connect(DensityNewPopup,SIGNAL(activated(int)),this,SLOT(NewDensitySel(int)) );	
		break;
		case NORMAL:
			NewNormalPopup=new QPopupMenu(NULL);
			NewNormalPopup->insertItem("Bumpmap",1);			
			NewNormalPopup->insertItem("Slopemap",2);			
        		NewNormalPopup->insertSeparator();
			NewNormalPopup->insertItem("Transformations",10);
			NewNormalPopup->insertItem("Turbulence",11);
			StandardPopup->insertItem("New",NewNormalPopup);
			connect(NewNormalPopup,SIGNAL(activated(int)),this,SLOT(NewNormalSel(int)) );	
		break;
		case PIGMENT:
		       	NewPigmentPopup=new QPopupMenu(NULL);
			NewPigmentPopup->insertItem("Color",1);
			NewPigmentPopup->insertItem("Imagemap",2);
			NewPigmentPopup->insertItem("Colorlist",3);
			NewPigmentPopup->insertItem("Colormap",4);
			NewPigmentPopup->insertSeparator();
			NewPigmentPopup->insertItem("Transformations",10);
			NewPigmentPopup->insertItem("Turbulence",11);

			//NewPigmentPopup->insertItem("Pigmentlist",5);
			//NewPigmentPopup->insertItem("Pigmentmap",6);
			StandardPopup->insertItem("New",NewPigmentPopup);
			connect(NewPigmentPopup,SIGNAL(activated(int)),this,SLOT(NewPigmentSel(int)) );	

		break;
		case TEXTUREBOOK:
		       	TextureBookPopup=new QPopupMenu(NULL);
			TextureBookPopup->insertItem("New Texture",30);
			TextureBookPopup->insertItem("New Book",31);
			StandardPopup->insertItem("New",TextureBookPopup);			
			connect(TextureBookPopup,SIGNAL(activated(int)),this,SLOT(NewTextureBookSel(int)) );	
		break;
		case TEXTURE:
			TextureNewPopup=new QPopupMenu(NULL);
			TextureNewPopup->insertItem("Pigment",1);
			TextureNewPopup->insertItem("Normal",2);
			TextureNewPopup->insertItem("Finish",3);
			TextureNewPopup->insertItem("Interior",4);
			TextureNewPopup->insertSeparator();
			TextureNewPopup->insertItem("Transformations",10);
			connect(TextureNewPopup,SIGNAL(activated(int)),this,SLOT(NewTextureItemSel(int)) );
			StandardPopup->insertItem("New",TextureNewPopup);
			StandardPopup->insertSeparator();
		break;
		default:
		break;
	}
	StandardPopup->insertItem("Rename",2);
	if (tb->getParent()!=NULL) {
		int t=tb->getParent()->getType();
		if ((t==TEXTURE)||(t==PIGMENT)||(t==COLORLIST)||(t==COLORMAP)||(t==INTERIOR)||(t==NORMAL)||(t=DENSITY)){
			StandardPopup->insertSeparator();
			StandardPopup->insertItem("Active",3);
			StandardPopup->setItemChecked(3,tb->active());
		}
	}

	StandardPopup->insertSeparator();
	//StandardPopup->insertItem("Cut",10);
	//StandardPopup->insertItbem("Copy",11);
	//StandardPopup->insertItem("Paste",12);
	StandardPopup->insertItem("Delete",13);	
	StandardPopup->insertSeparator();
	StandardPopup->insertItem("Properties",20);	
	connect(StandardPopup,SIGNAL(activated(int)),this,SLOT(StandardPopupSel(int)) );	
	
		
	if (tb->active()) StandardPopup->setItemChecked(3,true);	
	else StandardPopup->setItemChecked(3,false);

	StandardPopup->exec(QCursor::pos());

	if (NewPigmentPopup) {
		disconnect(NewPigmentPopup,SIGNAL(activated(int)),this,SLOT(NewPigmentSel(int)) );	
		delete NewPigmentPopup;NewPigmentPopup=NULL;
	}
	if (StandardPopup) {
		disconnect(StandardPopup,SIGNAL(activated(int)),this,SLOT(StandardPopupSel(int)) );	
		delete StandardPopup;StandardPopup=NULL;
	}
	if (TextureNewPopup) {
		disconnect(TextureNewPopup,SIGNAL(activated(int)),this,SLOT(NewTextureItemSel(int)) );	
		delete TextureNewPopup;TextureNewPopup=NULL;
	}
	if (TextureBookPopup) {
		disconnect(NewPigmentPopup,SIGNAL(activated(int)),this,SLOT(NewPigmentSel(int)) );	
		delete TextureBookPopup;TextureBookPopup=NULL;
	}	
	if (NewNormalPopup) {
		disconnect(NewNormalPopup,SIGNAL(activated(int)),this,SLOT(NewNormalSel(int)) );	
		delete NewNormalPopup;NewNormalPopup=NULL;
	}
	if (FinishNewPopup) {
		disconnect(FinishNewPopup,SIGNAL(activated(int)),this,SLOT(NewFinishSel(int)) );	
		delete FinishNewPopup;
	}
	if (PigmentListNewPopup) {
		disconnect(PigmentListNewPopup,SIGNAL(activated(int)),this,SLOT(NewPigmentListSel(int)) );	
		delete PigmentListNewPopup;
	}
	if (PigmentMapNewPopup) {
		disconnect(PigmentMapNewPopup,SIGNAL(activated(int)),this,SLOT(NewPigmentMapSel(int)) );	
		delete PigmentMapNewPopup;
	}
	if (SlopeMapNewPopup) {
		disconnect(SlopeMapNewPopup,SIGNAL(activated(int)),this,SLOT(NewSlopeMapSel(int)) );	
		delete SlopeMapNewPopup;
	}

	if (NormalListNewPopup) {
		disconnect(NormalListNewPopup,SIGNAL(activated(int)),this,SLOT(NewNormalListSel(int)) );	
		delete NormalListNewPopup;
	}
	if (NormalMapNewPopup) {
		disconnect(NormalMapNewPopup,SIGNAL(activated(int)),this,SLOT(NewNormalMapSel(int)) );	
		delete NormalMapNewPopup;
	}
	if (ColorListNewPopup) {
		disconnect(ColorListNewPopup,SIGNAL(activated(int)),this,SLOT(NewColorListSel(int)) );	
		delete ColorListNewPopup;
	}
	if (ColorMapNewPopup) {
		disconnect(ColorMapNewPopup,SIGNAL(activated(int)),this,SLOT(NewColorMapSel(int)) );	
		delete ColorMapNewPopup;
	}
	if (DensityNewPopup) {
		disconnect(DensityNewPopup,SIGNAL(activated(int)),this,SLOT(NewDensitySel(int)) );	
		delete DensityNewPopup;
	}
	if (InteriorNewPopup) {
		disconnect(InteriorNewPopup,SIGNAL(activated(int)),this,SLOT(NewInteriorSel(int)) );	
		delete InteriorNewPopup;
	}

}

void TextureView::NewFinishSel(int t)
{
TreeListItem *lastItem=(TreeListItem*)treelist->currentItem();
textureBase *tb=lastItem->getData();
	if (!tb) return;
	switch(t)
	{	
		case 10:  // Transformations
		{
			Transformations *tr=new Transformations(tb);
			tr->setParent(tb);
			tb->addElement( (textureBase *)tr,NULL);	
			updateItem(lastItem);			
		}
		break;
		case 11:  // Turbulence
		{
			Turbulence*tu=new Turbulence(tb);
			tu->setParent(tb);
			tb->addElement( (textureBase *)tu,NULL);	
			updateItem(lastItem);			
		}
		break;
		default:
		break;
	}
}

void TextureView::NewNormalSel(int t)
{
TreeListItem *lastItem=(TreeListItem*)treelist->currentItem();
textureBase *tb=lastItem->getData();

	lastItem->setOpen(true);
	switch(t) {
		case 1: //new Bumpmap;
		{			
			bumpMap *d=new bumpMap(tb);
			tb->add(d);
			updateItem(lastItem);
		}
		break;
		case 2: //new slopemap
		{			
			slopeMap *d=new slopeMap(tb);
			tb->add(d);
			updateItem(lastItem);
		}
		case 10:  // Transformations
		{
			Transformations *tr=new Transformations(tb);
			tr->setParent(tb);
			tb->addElement( (textureBase *)tr,NULL);	
			updateItem(lastItem);			
		}
		break;
		case 11:  // Turbulence
		{
			Turbulence*tu=new Turbulence(tb);
			tu->setParent(tb);
			tb->addElement( (textureBase *)tu,NULL);	
			updateItem(lastItem);			
		}
		break;
                default:
		break;		
	}
}

void TextureView::NewPigmentListSel(int t)
{
TreeListItem *lastItem=(TreeListItem*)treelist->currentItem();
textureBase *tb=((textureBase*)(lastItem->getData()))->getParent();
	if (!tb) return;
	lastItem->setOpen(true);
	switch(t)
	{
		case 1: //new;
		{			
			pigment *d=new pigment(tb);
			tb->add(d);
			updateItem(lastItem);
		}
		break;
		case 10:  // Transformations
		{
			Transformations *tr=new Transformations(tb);
			tr->setParent(tb);
			tb->addElement( (textureBase *)tr,NULL);	
			updateItem(lastItem);			
		}
		break;
		case 11:  // Turbulence
		{
			Turbulence*tu=new Turbulence(tb);
			tu->setParent(tb);
			tb->addElement( (textureBase *)tu,NULL);	
			updateItem(lastItem);			
		}
		break;
		default:
		break;
	}
}
void TextureView::NewPigmentMapSel(int t)
{
TreeListItem *lastItem=(TreeListItem*)treelist->currentItem();
textureBase *tb=lastItem->getData();
	if (!tb) return;
	lastItem->setOpen(true);
	switch(t)
	{		
		case 1: //new;
		{			
			//pigmentEntry *d=new pigmentEntry(tb);
			//tb->add(d);
			updateItem(lastItem);
		}
		break;
		case 10:  // Transformations
		{
			Transformations *tr=new Transformations(tb);
			tr->setParent(tb);
			tb->addElement( (textureBase *)tr,NULL);	
			updateItem(lastItem);			
		}
		break;
		case 11:  // Turbulence
		{
			Turbulence*tu=new Turbulence(tb);
			tu->setParent(tb);
			tb->addElement( (textureBase *)tu,NULL);	
			updateItem(lastItem);			
		}
		break;
		default:
		break;
	}
}
void TextureView::NewSlopeMapSel(int t)
{
TreeListItem *lastItem=(TreeListItem*)treelist->currentItem();
textureBase *tb=lastItem->getData();
	if (!tb) return;
	lastItem->setOpen(true);
	switch(t)
	{		
		case 1: //new;
		{			
			slopeEntry *d=new slopeEntry(tb);
			tb->add(d);
			updateItem(lastItem);
		}
		break;
		default:
		break;
	}
}


void TextureView::NormalMapSel(int t)
{
TreeListItem *lastItem=(TreeListItem*)treelist->currentItem();
textureBase *tb=lastItem->getData();
	if (!tb) return;
	lastItem->setOpen(true);
	switch(t)
	{
		case 1: //new;
		{			
			//normalEntry *d=new normalEntry(tb);
			//tb->add(d);
			updateItem(lastItem);
		}
		break;
		case 10:  // Transformations
		{
			Transformations *tr=new Transformations(tb);
			tr->setParent(tb);
			tb->addElement( (textureBase *)tr,NULL);	
			updateItem(lastItem);			
		}
		break;
		case 11:  // Turbulence
		{
			Turbulence*tu=new Turbulence(tb);
			tu->setParent(tb);
			tb->addElement( (textureBase *)tu,NULL);	
			updateItem(lastItem);			
		}
		break;
		default:
		break;
	}
}
void TextureView::NormalListSel(int t)
{
TreeListItem *lastItem=(TreeListItem*)treelist->currentItem();
textureBase *tb=lastItem->getData();
	if (!tb) return;
	lastItem->setOpen(true);
	switch(t)
	{
		case 1: //new;
		{			
			normal *d=new normal(tb);
			tb->add(d);
			updateItem(lastItem);
		}
		break;
		case 10:  // Transformations
		{
			Transformations *tr=new Transformations(tb);
			tr->setParent(tb);
			tb->addElement( (textureBase *)tr,NULL);	
			updateItem(lastItem);			
		}
		break;
		case 11:  // Turbulence
		{
			Turbulence*tu=new Turbulence(tb);
			tu->setParent(tb);
			tb->addElement( (textureBase *)tu,NULL);	
			updateItem(lastItem);			
		}
		break;
		default:
		break;
	}
}
void TextureView::NewColorMapSel(int t)
{
TreeListItem *lastItem=(TreeListItem*)treelist->currentItem();
textureBase *tb=lastItem->getData();
	if (!tb) return;
	lastItem->setOpen(true);
	switch(t)
	{
		case 1: //new;
		{			
			colorEntry *d=new colorEntry(tb);
			tb->add(d);
			updateItem(lastItem);
		}
		break;
		case 10:  // Transformations
		{
			Transformations *tr=new Transformations(tb);
			tr->setParent(tb);
			tb->addElement( (textureBase *)tr,NULL);	
			updateItem(lastItem);			
		}
		break;
		case 11:  // Turbulence
		{
			Turbulence*tu=new Turbulence(tb);
			tu->setParent(tb);
			tb->addElement( (textureBase *)tu,NULL);	
			updateItem(lastItem);			
		}
		break;
		default:
		break;
	}
}
void TextureView::NewColorListSel(int t)
{
TreeListItem *lastItem=(TreeListItem*)treelist->currentItem();
textureBase *tb=lastItem->getData();
	if (!tb) return;
	lastItem->setOpen(true);
	switch(t)
	{
		case 1: //new;
		{			
			color *d=new color(tb);
			tb->add(d);
			updateItem(lastItem);
		}
		break;
		case 10:  // Transformations
		{
			Transformations *tr=new Transformations(tb);
			tr->setParent(tb);
			tb->addElement( (textureBase *)tr,NULL);	
			updateItem(lastItem);			
		}
		break;
		case 11:  // Turbulence
		{
			Turbulence*tu=new Turbulence(tb);
			tu->setParent(tb);
			tb->addElement( (textureBase *)tu,NULL);	
			updateItem(lastItem);			
		}
		break;
		default:
		break;
	}
}
void TextureView::NewInteriorSel(int t)
{
TreeListItem *lastItem=(TreeListItem*)treelist->currentItem();
textureBase *tb=lastItem->getData();
	if (!tb) return;
	lastItem->setOpen(true);
	switch(t)
	{
		case 1: //new;
		{			
			Density *d=new Density(tb);
			tb->add(d);
			updateItem(lastItem);
		}
		break;
		case 10:  // Transformations
		{
			Transformations *tr=new Transformations(tb);
			tr->setParent(tb);
			tb->addElement( (textureBase *)tr,NULL);	
			updateItem(lastItem);			
		}
		break;
		case 11:  // Turbulence
		{
			Turbulence*tu=new Turbulence(tb);
			tu->setParent(tb);
			tb->addElement( (textureBase *)tu,NULL);	
			updateItem(lastItem);			
		}
		break;
		default:
		break;
	}
}
void TextureView::NewDensitySel(int t)
{
TreeListItem *lastItem=(TreeListItem*)treelist->currentItem();
textureBase *tb=lastItem->getData();
	if (!tb) return;
	lastItem->setOpen(true);
	switch(t)
	{
		case 1: //new;
		{			
			colorEntry *d=new colorEntry(tb);
			tb->add(d);
			updateItem(lastItem);
		}
		break;
		case 10:  // Transformations
		{
			Transformations *tr=new Transformations(tb);
			tr->setParent(tb);
			tb->addElement( (textureBase *)tr,NULL);	
			updateItem(lastItem);			
		}
		break;
		case 11:  // Turbulence
		{
			Turbulence*tu=new Turbulence(tb);
			tu->setParent(tb);
			tb->addElement( (textureBase *)tu,NULL);	
			updateItem(lastItem);			
		}
		break;
		default:
		break;
	}
}

void TextureView::NewTextureItemSel(int x)
{

pigment *pi;
interior *in;
finish *fi;
normal *no;
TreeListItem *lastItem=(TreeListItem*)treelist->currentItem();
textureBase *tb=(textureBase *)lastItem->getData();


	if (tb->getType()!=TEXTURE) return;

	lastItem->setOpen(true);

	switch(x)
	{
		case 1: //Pigment
			pi=new pigment(tb);
			tb->addElement( (textureBase *)pi,NULL);	
			updateItem(lastItem);			
		break;		
		case 2: //Normal
			no=new normal(tb);
			tb->addElement( (textureBase *)no,NULL);	
			updateItem(lastItem);			
		break;	
		case 3: //Finish
			fi=new finish(tb);
			tb->addElement( (textureBase *)fi,NULL);	
			updateItem(lastItem);			
		break;		
		case 4: //Interior
			in=new interior(tb);
			tb->addElement( (textureBase *)in,NULL);	
			updateItem(lastItem);			
		break;	
		case 10:  // Transformations
		{
			Transformations *tr=new Transformations(tb);
			tr->setParent(tb);
			tb->addElement( (textureBase *)tr,NULL);	
			updateItem(lastItem);			
		}
		break;
		default:
		break;
	}

}

void TextureView::NewPigmentSel(int x)
{
color *c;
colorList *cl;
colorMap *cm;
imageMap *im;
Transformations *tr;
Turbulence *tu;
TreeListItem *lastItem=(TreeListItem*)treelist->currentItem();
textureBase *tb=(textureBase *)lastItem->getData();


	if (tb->getType()!=PIGMENT) return;
	lastItem->setOpen(true);
	switch(x)
	{
		case 1: //Color
			c=new color(tb);
			c->setParent(tb);
			tb->addElement( (textureBase *)c,NULL);	
			updateItem(lastItem);			
		break;		
		case 2: // Imagemap
			im=new imageMap(tb);
			im->setParent(tb);
			tb->addElement( (textureBase *)im,NULL);	
			updateItem(lastItem);			
		break;
		case 3:  // Colorlist
			cl=new colorList(tb);
			cl->setParent(tb);
			tb->addElement( cl,NULL);	
			updateItem(lastItem);			
		break;
		case 4:  // Colormap
			cm=new colorMap(tb);
			cm->setParent(tb);
			tb->addElement( cm,NULL);	
			updateItem(lastItem);			
		break;
		case 10:  // Transformations
			tr=new Transformations(tb);
			tr->setParent(tb);
			tb->addElement( (textureBase *)tr,NULL);	
			updateItem(lastItem);			
		break;
		case 11:  // Turbulence
			tu=new Turbulence(tb);
			tu->setParent(tb);
			tb->addElement( (textureBase *)tu,NULL);	
			updateItem(lastItem);			
		break;
		default:
		break;
	}
}

void TextureView::selChanged(QListViewItem *qli)
{
///textureBase *tb;
/*
	if (lastItem) {
		tb=(textureBase *)(((TreeListItem *)lastItem)->getData());
		tb->setSelected(false);
		if ((lastitem)&&(lastItem!=treelist)) lastItem->setSelected(false);
	}
	tb=(textureBase *)(((TreeListItem *)qli)->getData());	
	tb->setSelected(true);
	if ( qli->isExpandable()==true) lastFolder=(TreeListItem*)qli;
	else lastFolder=(TreeListItem *)qli->parent();
	lastItem=(TreeListItem*)qli;
*/
}

void TextureView::doubleClicked(QListViewItem *qli)
{
TreeListItem *tli=(TreeListItem *)qli;
textureBase *tb;
TreeListItem *lastItem=(TreeListItem*)treelist->currentItem();

	selChanged(qli);
	tb=(textureBase *)lastItem->getData();	
	tb->setOpen(tli->isOpen() );
	if (!tb) return;
	switch(tb->getType()) {
		case TURBULENCEMODIFIER:
		{
			Turbulence *tu=(Turbulence*)tb;
			TurbulenceWidget *td=new TurbulenceWidget(NULL,tu);
			td->exec();
			updateItem(lastItem);
		}
		break;
		case TRANSFORMATIONS:
		{
			Transformations *tr=(Transformations*)tb;
			TransformationsWidget *td=new TransformationsWidget(NULL,tr);
			td->exec();
			updateItem(lastItem);
		}
		break;
		case COLOR:
			{
				color *c=(color*)tb;
				ColorDialog *cd=new ColorDialog(NULL,c);
				cd->exec();
				updateItem(lastItem);
			}
		break;
		case COLORENTRY:
			{
				colorEntry *c=(colorEntry*)tb;
				ColorEntryDialog *cd=new ColorEntryDialog(NULL,c);
				colorMap *cm=(colorMap*)c->getParent();
				cd->exec();
				cm->sortColorMap();				
				updateItem( (TreeListItem *)lastItem->parent());
			}

		break;
		case IMAGEMAP:
			{
				imageMap *im=(imageMap*)tb;
				ImageMapDialog *imd=new ImageMapDialog(NULL,im);
				imd->exec();
				updateItem(lastItem);
			}

		break;
		case BUMPMAP:
			{
				bumpMap *bu=(bumpMap *)tb;
				BumpMapDialog *bmd=new BumpMapDialog(NULL,bu);
       				bmd->exec();
				lastItem->setText(0,(const char *)bu->getName());
				lastItem->setText(infoColumn,(const char *)bu->getInfo());
				updateItem(lastItem);
				delete bmd;
                         }
		break;
		case SLOPEENTRY:
			{
				slopeEntry *se=(slopeEntry *)tb;
				SlopeEntryDialog *bmd=new SlopeEntryDialog(NULL,se);
       				bmd->exec();
				lastItem->setText(0,(const char *)se->getName());
				lastItem->setText(infoColumn,(const char *)se->getInfo());
				updateItem(lastItem);
				delete bmd;
                         }
		break;
		default:
		break;
	}

}

void TextureView::paintEvent(QPaintEvent *qp)
{
	int w=width();
	int h=height();

	treelist->setGeometry(0,0,w,h);
	treelist->setColumnWidth(nameColumn,4*w/10); 	// Baumstruktur
	treelist->setColumnWidth(infoColumn,5*w/10);	// User-Infos
	treelist->setColumnWidth(activeColumn,1*w/10);  // Aktiv

	//if (newlib) newlib->setGeometry(3,10,buttonw-5,40);
	//newbook->setGeometry(3,83,buttonw-5,40);
	//inslib->setGeometry(3,133,buttonw-5,40);
	//savelib->setGeometry(3,183,buttonw-5,40);

	QWidget::paintEvent(qp);

}

//======================================================================

TextureListView::TextureListView(QWidget *p,char *n):TreeList(p,n)
{
	DnDPopup=new QPopupMenu(NULL);
	DnDPopup->insertItem("Copy",0);
	//DnDPopup->insertItem("Move",1);	

	tview=(TextureView *)p;
}

void TextureListView::setLib(TextureLibrary *t)
{
	tlib=t;
}

TextureListView::~TextureListView()
{
}


void	TextureListView::startDragCopy(QListViewItem *item,QWidget *dragsource)
{
	if(!item || !dragsource)
		return;

	QPixmap		pixmap;
	Drag3DDS	*drag;
	textureBase	*tb;

	tb=((TreeListItem *)item)->getData();
	if (!tb) return;

	pixmap = *item->pixmap(0);

	drag = new Drag3DDS("3dds/texture",dragsource);
	drag->encode(tb);
	drag->setPixmap(pixmap);
	drag->dragCopy();
}

void	TextureListView::startDragMove(QListViewItem *item,QWidget *dragsource)
{
}

void	TextureListView::dragMoveEvent(QDragMoveEvent *dme)
{
	QPoint		p = dme->pos();
	TreeListItem	*li = (TreeListItem *)itemAt(p);



		
	if (Drag3DDS::canDecode(dme,"3dds/texture")) {
		textureBase	*t;
		Drag3DDS::decode( (QDragMoveEvent *)dme,&t, (const char *)"3dds/texture");// && t);
		if (li) {		
			textureBase	*tb=(textureBase *)li->getData();
			if (tb->canAdd(t)==true ) dme->accept();
			else dme->ignore();
		} else{
			if ((t->getType()==TEXTURE)||(t->getType()==TEXTUREBOOK)) {
				dme->accept();
			} else dme->ignore();
		}
	} else dme->ignore();
}

void	TextureListView::dropEvent(QDropEvent *de)
{

	textureBase		*t;
	int x;

	if (Drag3DDS::decode(de,&t,"3dds/texture") && t)
	{
		printf("Dropped Texture over Textureview\n");

		QPoint		p = de->pos();
		QListViewItem	*li = itemAt(p);
		if (li!=NULL) {
			textureBase 	*tb=((TreeListItem *)li)->getData();
			if (tb->isEqual(t)==true) return;

			x=DnDPopup->exec(QCursor::pos());

			if (x==0) {
				printf("Copy %s to %s\n",t->getName(),tb->getName());
				tb->add(t);        	
                	}
			if (x==1){
				printf("Move\n");
				tb->add(t);        	
			}
			//x=-1 :Escape gedrckt....
        		tview->updateItem( (TreeListItem *)li);
			return;
		} else {
			x=DnDPopup->exec(QCursor::pos());

			if (x==0) {
				tlib->add(t);        	
                	}
			if (x==1){
				tlib->add(t);        	
			}
			tview->updateAll();
			return;
		}
	}


}

void	TextureListView::dragEnterEvent(QDragEnterEvent *de)
{
	if(Drag3DDS::canDecode(de,"3dds/texture"))
	{
		de->accept();
	}
}

void	TextureListView::dragLeaveEvent(QDragLeaveEvent *)
{
    // Give the user some feedback...
}

