/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** normaldialog.cpp
*/
#include "normaldialog.h"
#include "normaldialog.moc"



NormalWidget::NormalWidget(QWidget *parent,normal *n) :
	QWidget(parent,"NormalWidget")
{
textureBase *tb;
QWidget *w;
int x,a=0;

#ifdef DEBUG
	printf("Entering NOrmalWidget Constructor\n");
#endif

	tab=new TabWidget(this,"",1);

	nor=n;
	transformations=NULL;
	tw=NULL;
	turbulence=NULL;
	tbw=NULL;
	label4=NULL;

	tb=nor->getFirstElement();
	while (tb!=NULL) {

		switch(tb->getType()) {
			case BUMPMAP:
				w=(QWidget *)new BumpMapWidget(NULL,(bumpMap *)tb);
	     			bumpwidget.append( (BumpMapWidget *)w );
				widgetlist.append(w);
				x=widgetlist.length()-1;
				tab->addWidget(w,x,tb->getName() );
				if (tb->active()==true) a=x;
			break;
			case TRANSFORMATIONS:
				transformations=new QPushButton("Transformations...",this);
				connect (transformations,SIGNAL(clicked()),this,SLOT(transformationsPressed()) );
				tw=new TransformationsWidget(NULL,(Transformations*)tb );
				tw->setCaption("Transformations");
			break;
			case TURBULENCEMODIFIER:
				turbulence=new QPushButton("Turbulence...",this);
				connect (turbulence,SIGNAL(clicked()),this,SLOT(turbulencePressed()) );
				tbw=new TurbulenceWidget(NULL,(Turbulence*)tb );
				tbw->setCaption("Turbulence");

			break;
			default:
			break;
		}
		tb=nor->getNextElement();
	}

	line1=new QLineEdit(this);
        label1=new QLabel("Name:",this);
	line1->setText(nor->getName() );

	if ((bumpwidget.length()==0) )label4=new QLabel("Nothing to edit...",this);
	else tab->select(a);

	active=new QCheckBox("Active",this);
	active->setChecked(nor->active() );

	addElement=new QPushButton("Add...",this);
	connect(addElement,SIGNAL(clicked()),this,SLOT(addPressed()) );

#ifdef DEBUG
	printf("Exiting NormalWidget Constructor\n");
#endif
}

void NormalWidget::addPressed()
{
QWidget *w;
int x;
textureBase *tb;
QPopupMenu *Elements;

	Elements=new QPopupMenu(this);
	Elements->insertItem("Bumpmap",1);
	switch(Elements->exec(QCursor::pos() )) {
		case 1:
			tb=new bumpMap(nor);
			w=(QWidget *)new BumpMapWidget(NULL,(bumpMap *)tb);
			bumpwidget.append( (BumpMapWidget *)w );
			widgetlist.append(w);
			x=widgetlist.length()-1;
			tab->addWidget(w,x,tb->getName() );
        		tab->select(x);
			nor->add(tb);
		break;
		default:	
		break;
	}
	delete Elements;
	if (label4) {delete label4;label4=NULL;}
}

NormalWidget::~NormalWidget()
{
}

void NormalWidget::getNormal()
{
int i;	
	for (i=0;i<bumpwidget.length();i++) if (bumpwidget[i]) bumpwidget[i]->getBumpMap();
	nor->setActive( active->isChecked(),NULL);
	nor->setName(line1->text() );
	if (tw) tw->getTransformations();
	if (tbw) tbw->getTurbulence();

}

void NormalWidget::transformationsPressed()
{
	tw->resize(180,440);
	tw->setMinimumSize(180,440);
	tw->exec();
}
void NormalWidget::turbulencePressed()
{
	tbw->resize(270,170);
	tbw->setMinimumSize(270,170);
	tbw->exec();
}


void NormalWidget::paintEvent(QPaintEvent* qp)
{
	int w=width();
	int h=height();
                       	

	label1->setGeometry(10,10,50,25);
	line1->setGeometry(65,10,150,25);

	active->setGeometry(220,10,60,25);
	

	if (emptywidget) label4->setGeometry(10,10,w-10,25);
	if (transformations) transformations->setGeometry(w/1.5+20,100,110,25);
	if (turbulence) turbulence->setGeometry(w/1.5+20,130,110,25);

 	tab->setGeometry(15,65,w/1.5-10,h-90);	
	addElement->setGeometry(20+w/1.5,65,110,25);

	if (label4) label4->setGeometry(50,120,120,30);

	///QWidget::paintEvent(qp);
}


//----------------------------------------------------------

NormalDialog::NormalDialog(QWidget *parent,normal *n) :
	QDialog(parent,"NormalDialog",true)
{

	ok=new QPushButton("Okay",this);
	cancel=new QPushButton("Cancel",this);

	nw=new NormalWidget(this,n);

	connect (ok,SIGNAL(pressed()),this,SLOT(okayPressed()) );
	connect (cancel,SIGNAL(pressed()),this,SLOT(cancelPressed()) );

	resize(500,370);
	setMinimumSize(500,370);
	setMaximumSize(500,370);

}


void NormalDialog::okayPressed()
{  	
	nw->getNormal();   //Widgetwerte in Pointer sichern
	QDialog::done(1);
}

void NormalDialog::cancelPressed()
{
	QDialog::done(0);
}

NormalDialog::~NormalDialog()
{
}

void NormalDialog::paintEvent(QPaintEvent* qp)
{
	int w=width();
	int h=height();
                       	
	cancel->setGeometry(w-65,h-30,60,25);
	ok->setGeometry(w-65-45,h-30,40,25);
	nw->setGeometry(0,0,w,h-35);

	QDialog::paintEvent(qp);
}

