/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** densitydialog.cpp
*/
#include "densitydialog.h"
#include "densitydialog.moc"




DensityWidget::DensityWidget(QWidget *parent,Density *d) :
	QWidget(parent,"DensityWidget")
{

int x;
textureBase *tb;
QWidget *w;

	de=d;


	label4=NULL;
	tw=NULL;
	tbw=NULL;
	turbulence=NULL;
	transformations=NULL;
	pmd=NULL;

	tab=new TabWidget(this,"Color:",1);

	tb=de->getFirstElement();
	while (tb!=NULL) {

		switch(tb->getType()) {
			case COLORENTRY:
				w=(QWidget *)new ColorEntryWidget(NULL,(colorEntry *)tb);
	     			colorwidget.append( (ColorEntryWidget *)w );
				widgetlist.append (w);
				x=widgetlist.length()-1;
				tab->addWidget(w,x,tb->getName() );

			break;
			case TRANSFORMATIONS:
				transformations=new QPushButton("Transformations...",this);
				connect (transformations,SIGNAL(clicked()),this,SLOT(transformationsPressed()) );
				tw=new TransformationsWidget(NULL,(Transformations*)tb );
				tw->setCaption("Transformations");
			break;
			case TURBULENCEMODIFIER:
				turbulence=new QPushButton("Turbulence...",this);
				connect (turbulence,SIGNAL(clicked()),this,SLOT(turbulencePressed()) );
				tbw=new TurbulenceWidget(NULL,(Turbulence*)tb );
				tbw->setCaption("Turbulence");

			break;
			default:
			break;
		}

		tb=de->getNextElement();
	}


	line=new QLineEdit(this);
	line->setText(de->getName());
	n=new QLabel("Name:",this);

	pmd=new PatternModifierWidget(this,de->getMapModifier() );

	if (colorwidget.length()==0) label4=new QLabel("no entrys in map ! ",this);	
	
	active=new QCheckBox("Active",this);
	active->setChecked(de->active() );

	addElement=new QPushButton("Add Element",this);

	connect(addElement,SIGNAL(clicked()),this,SLOT(addPressed()) );

	resize(200,300);
	
}

void DensityWidget::addPressed()
{
QWidget *w;
int x;
textureBase *tb;
	tb=new colorEntry(de);
	de->add(tb);
	w=(QWidget *)new ColorEntryWidget(NULL,(colorEntry *)tb);
	colorwidget.append( (ColorEntryWidget *)w );
	widgetlist.append (w);
	x=widgetlist.length()-1;
	tab->addWidget(w,x,tb->getName() );
	tab->select(x);
	if (label4) delete label4;
	label4=NULL;
}

DensityWidget::~DensityWidget()
{
}

void DensityWidget::transformationsPressed()
{
	tw->resize(200,440);
	tw->setMinimumSize(200,440);
	tw->exec();
}

void DensityWidget::turbulencePressed()
{
	tbw->resize(270,170);
	tbw->setMinimumSize(270,170);
	tbw->exec();
}



void DensityWidget::getDensity()
{
int i;
      	if (tw) tw->getTransformations();
	if (tbw) tbw->getTurbulence();
	de->setName( (char *)line->text());
	de->setActive(active->isChecked(),NULL);
	pmd->getPatternModifier();
	for (i=0;i<colorwidget.length();i++) if (colorwidget[i]) colorwidget[i]->getColorEntry();

}

void DensityWidget::paintEvent(QPaintEvent* qp)
{
	//int w=width();
	//int h=height();
	
	
	n->setGeometry(10,10,60,25);
	line->setGeometry(75,10,190,25);

	active->setGeometry(270,10,80,25);
	addElement->setGeometry(355,10,110,25);

        if (label4) {
		label4->setGeometry(250,60,280,25);
		tab->setGeometry(-400,-300,320,210);
	}
	else tab->setGeometry(210,35,300,168);


	if (pmd) pmd->setGeometry(10,40,200,150);

	if (transformations) transformations->setGeometry(10,200,110,25);
	if (turbulence) turbulence->setGeometry(10,230,110,25);

	
	QWidget::paintEvent(qp);
}

//------------------------------------------------------------------------

DensityDialog::DensityDialog(QWidget *parent,Density *de) :
	QDialog(parent,"DensityDialog",true)
{

	setCaption("Density");

	ok=new QPushButton("Okay",this);
	cancel=new QPushButton("Cancel",this);

	pw=new DensityWidget(this,de);

	connect (ok,SIGNAL(pressed()),this,SLOT(okayPressed()) );
	connect (cancel,SIGNAL(pressed()),this,SLOT(cancelPressed()) );

	resize(560,300);
	setMinimumSize(560,300);
	setMaximumSize(560,300);
	
}

DensityDialog::~DensityDialog()
{
}


void DensityDialog::cancelPressed()
{
	QDialog::done(0);
}

void DensityDialog::okayPressed()
{
	pw->getDensity();
	QDialog::done(1);
}

void DensityDialog::paintEvent(QPaintEvent* qp)
{
	int w=width();
	int h=height();


	
	cancel->setGeometry(w-65,h-30,60,25);
	ok->setGeometry(w-65-45,h-30,40,25);

	pw->setGeometry(0,0,w,h-35);

	QDialog::paintEvent(qp);
}



