/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** drag3dds.h
*/
#ifndef __DRAG3DDS_H__
#define __DRAG3DDS_H__

#include <qdragobject.h>

#include <classes.h>
#include "../../3d/textures/texturebase.h"

class Drag3DDS : public QStoredDrag
{
Q_OBJECT
public:
	Drag3DDS(const char *mimetype,QWidget *dragSource=0,const char *name = 0);

	const char	*format(int i) const;

	bool		encode(base *);
	bool		encode(textureBase *);
 	static bool	canDecode(QDragMoveEvent *e,const char *format);
	static bool	decode(QDropEvent *e,base **,const char *format);
	static bool	decode(QDragMoveEvent *e,textureBase **,const char *format);
	static bool	decode(QDropEvent *e,textureBase **,const char *format);

};


#endif




