/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** pigmentmap.h
*/
#ifndef __PIGMENTMAP_H__
#define __PIGMENTMAP_H__

#include <chunk.h>
#include <list.h>
#include "pigmententry.h"
#include "mapmodifier.h"


class pigmentEntry;
class pigment;

class pigmentMap:public virtual chunk 
{
public:
	enum FUNCTION
	{
		Checker,
		Marble,
		Wood,
		Granite,
		Leopard,
		Onion,
		Brick,
		Hexagon,
		Agate,
		Average,
		Crackle,
		Dents,
		Mandel,
		Waves,
		Spotted,
		Ripples,
		Gradient,
		Radial,
		Spiral1,
		Spiral2,
		Bozo,
		Bumps,
		Wrinkles,
		NFunctions
	};
	pigmentMap();
	~pigmentMap();

	mapmodifier	modifier;

	void 	setPigmentMapFunction(FUNCTION f);
	int 	getPigmentMapFunction();

	char *getInfo();

	void	addPigmentMapEntry(double, pigment *);
	void	deletePigmentMapEntry(int);
	void 	clearPigmentMap();
	void	sortPigmentMap();
	void	setName(char *);
	char *getName();

	pigmentEntry 	*getPigmentMapEntry(int);

	char 	*getPigmentMapFunctionName();
	char 	*getPigmentMapFunctionNameList(int);

	int	load(media *,int);
	int	save(media *);
	int	exportPOV(FILE*,int,int,int);

protected:
	FUNCTION	fn;
	char *name,*info;
	list<pigmentEntry *>		pigmentEntryList;

};


#endif


