/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** pigmentmap.cpp
*/
#include "pigmentmap.h"

#include <misc.h>

static char	fnname[pigmentMap::NFunctions][20] =
		{
			"checker",
			"marble",
			"wood",
			"granite",
			"leopard",
			"onion",
			"brick",
			"hexagon",
			"agate",
			"average",
			"crackle",
			"dents",
			"mandel",
			"waves",
			"spotted",
			"ripples",
			"gradient",
			"radial",
			"spiral1",
			"spiral2",
			"bozo",
			"bumps",
			"wrinkles",
		};

pigmentMap::pigmentMap() :chunk()
{
	fn=Agate;
	/*
	pigmentEntryList.append( new pigmentEntry(0.3,new pigment(0) ) );
	pigmentEntryList.append( new pigmentEntry(0.8,new pigment(2) ) );
	*/
	name=strdup("");
	info=strdup("no info avaiable");
}

char *pigmentMap::getInfo()
{
	return info;
}

void pigmentMap::clearPigmentMap()
{
	pigmentEntryList.empty();	
}

void pigmentMap::sortPigmentMap()
{
int a,i,j;
pigmentEntry *pe;
	#ifdef DEBUG
		printf("sorting pigmentMap\n");
	#endif
	a=pigmentEntryList.length();
	for (i=2;i<a;i++) {
		for (j=a;j>i;j--) {
			if ( pigmentEntryList[j-1]->getPigmentRange()>pigmentEntryList[j]->getPigmentRange() ) {
				pe=pigmentEntryList.at( (long)j-1);
				pigmentEntryList[j-1]=pigmentEntryList[j];
				pigmentEntryList.at(j)=pe;
			}
		}
	}
	#ifdef DEBUG
		printf("PigmentMap sorted\n");
	#endif
}

void pigmentMap::addPigmentMapEntry(double v, pigment *p)
{
	pigmentEntryList.insert( new pigmentEntry(v,p) );
}

void pigmentMap::deletePigmentMapEntry(int n)
{
	pigmentEntryList.deleteAt(n);
}

pigmentEntry *pigmentMap::getPigmentMapEntry(int n)
{
	return pigmentEntryList.at(n);
}

pigmentMap::~pigmentMap()
{
	if (name) free(name);
	if (info) free(info);
}

char *pigmentMap::getName()
{
	return name;
}

void pigmentMap::setName(char *n)
{
	if (name) free(name);
	name=strdup(n);
}

void pigmentMap::setPigmentMapFunction(FUNCTION f)
{
	fn=f;
}

int pigmentMap::getPigmentMapFunction()
{
	return fn;
}

char *pigmentMap::getPigmentMapFunctionName()
{
	printf("%d\n",fn );
	return fnname[fn];
}

char *pigmentMap::getPigmentMapFunctionNameList(int n)
{
	return fnname[n];
}

int	pigmentMap::load(media *m,int l)
{
	int x,i;
	char	chunk[4];
	bool 	read;
	int	len,pos = m->tell();

	if(!m)
		return -1;
	i=0;

	setMedia(m);

	#ifdef DEBUG
		printf("loading pigmentMap\n");
	#endif

	m->read(&fn,4);
	m->read(&x,4);
	do {
		m->read(chunk,4);
		m->read(&len,4);
		read=false;

		if(strncmp(chunk,"PGME",4) == 0) {
			addPigmentMapEntry(0,new pigment() );
			getPigmentMapEntry(i)->load(m,len);
			read=true;
			i++;
		}
		if(strncmp(chunk,"MAPM",4) == 0) {
			modifier.load(m,len);
			read=true;
		}
		if (read==false) { m->seek(len,SEEK_CUR); }
	} while (m->tell()< (pos+l) );
	m->seek(pos+l,SEEK_SET); // Man weiss ja nie...

	#ifdef DEBUG
		printf("PigmentMap loaded\n");
	#endif
	return 0;
}

int	pigmentMap::save(media *m)
{
int i;
	if(!m) return -1;
	#ifdef DEBUG
		printf("saving pigmentMap\n");
	#endif
	setMedia(m);
	
	writeChunk("PIGM");

	SI(fn);
	SI(pigmentEntryList.length());
	for (i=0;i<pigmentEntryList.length();i++)  {
		pigmentEntryList[i]->save(m);			
	}
	modifier.save(m);
	writeChunkLen();
	#ifdef DEBUG
		printf("PigmentMap saved\n");
	#endif
	return 0;
}

int pigmentMap::exportPOV(FILE *fp,int tab,int tabsize,int a)
{
int i;
	if(!fp)return -1;

	#ifdef DEBUG
		printf("exporting pigmentMap (POV)\n");
	#endif
	printTab(fp,tab);
	fprintf(fp,"%s\n",getPigmentMapFunctionName() );

	printTab(fp,tab);
	fprintf(fp,"pigment_map {\n" );	


	pigmentEntryList.getFirst()->exportPOV(fp,tab+tabsize,tabsize,a);
	for (i=1;i<pigmentEntryList.length();i++)  {
		pigmentEntryList[i]->exportPOV(fp,tab+tabsize,tabsize,a);			
	}
	modifier.exportPOV(fp,tab,tabsize,a,false);
	printTab(fp,tab);
	fprintf(fp,"}\n" );	
	#ifdef DEBUG
		printf("PigmentMap exported (POV)\n");
	#endif
	return 0;
}

