/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** patternmodifier_bak.h
*/
#ifndef __PATTERNMODIFER_H__
#define __PATTERNMODIFER_H__

#include <misc.h>
#include <list.h>
#include <chunk.h>
#include <stdio.h>


class patternmodifier:public virtual chunk
{
protected:

	Vector3	scale, rotate, translate;
	Vector3 turbulence, blackhole, repeat; 
	Vector3 repeatwarp, offsetwarp, flipwarp;
	Vector3 turbulencewarp;
	double 	octaves, omega, lambda, fall_off;
	double 	strength, inverse,blackholeradius;
	int	mode; 
	//0:nix, 1:turbulence,2:simplewarp,3:blackhole


	void saveVector(FILE *, Vector3);
	void readVector(FILE *, Vector3);
	void exportPOVVector(FILE *, Vector3);

public:

	patternmodifier();	
	~patternmodifier();
	
	void	setMode(int);
	void 	setScale(Vector3);
	void 	setRotate(Vector3);
	void 	setTranslate(Vector3);
	void 	setTurbulence(Vector3);
	void 	setTurbulenceWarp(Vector3);
	void 	setBlackHole(Vector3);
	void	setBlackHoleRadius(double);
	void 	setRepeat(Vector3);
	void 	setRepeatWarp(Vector3);
	void 	setOffsetWarp(Vector3);
	void 	setFlipWarp(Vector3);
	void 	setOctaves(double);
	void 	setOmega(double);
	void 	setLambda(double);
	void 	setFallOff(double);
	void 	setStrength(double);
	void 	setInverse(double);
	
	int	getMode();
	Vector3	getScale();
	Vector3	getRotate();
	Vector3	getTranslate();
	Vector3	getTurbulence();
	Vector3	getTurbulenceWarp();
	Vector3	getBlackHole();
	double 	getBlackHoleRadius();
	Vector3	getRepeat();
	Vector3	getRepeatWarp();
	Vector3	getOffsetWarp();
	Vector3	getFlipWarp();
	double 	getOctaves();
	double 	getOmega();
	double 	getLambda();
	double 	getFallOff();
	double 	getStrength();
	double 	getInverse();

	int	save(FILE*);
	int	load(FILE*,int);

	int	exportPOV(FILE*,int,int, int);
};

#endif
