/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** finish.h
*/
#ifndef __FINISH_H__
#define __FINISH_H__

#include "texturebase.h"
#include "turbulence.h"
#include "transformations.h"
#include "color.h"

class finish : public textureBase
{
protected:

	color		*ambient;
	double		diffuse;
	double		brilliance;

	double		phong;
	double		phong_size;
	double		specular;
	double		roughness;
	bool		metallic;

	double 		reflection;
	double		irid_amount;
	double		irid_thickness;
	double		irid_turbulence;

	list<textureBase *> elements;
	int elementnr;
public:

	finish(textureBase *p);
	~finish();

      	textureBase	*getFirstElement();
	textureBase	*getNextElement();
	void	addElement(textureBase *,textureBase *a=NULL);

	void	setActive(bool a,textureBase *tb);
	void 	remove(textureBase *);

	bool		isExportable();

	void		setAmbient(color *);
	color		*getAmbient();
	void 		setBrilliance(double );
	double		getBrilliance();
	void		setDiffuse(double );
	double		getDiffuse();


	void		setPhong(double);
	double		getPhong();
	void		setPhongSize(double);
	double		getPhongSize();
	void		setSpecular(double);
	double		getSpecular();
	void		setRoughness(double);
	double		getRoughness();
	void		setMetallic(bool);
	bool		getMetallic();

	void		setReflection(double);
	double		getReflection();
	void		setIridAmount(double);
	double		getIridAmount();
	void		setIridThickness(double);
	double		getIridThickness();
	void		setIridTurbulence(double);
	double		getIridTurbulence();
	
	bool		isEqual(textureBase *);
		
	bool		canAdd(textureBase *);
	void		add(textureBase *);

	int		load(media*,int);
	int		save(media*);

	int		exportPOV(FILE*,int,int,int);
};


#endif


