/******************************************************************************
**                                                                           **
**    k4de - 3d-editor for the K Desktop Enviroment                          **
**                                                                           **
**    Copyright (C) 1999  Tobias Wollgam (tobias.wollgam@gmx.de)             **
**    Copyright (C) 1999  Markus Weber (mweber@gmx.de)                       **
**                                                                           **
**    This program is free software; you can redistribute it and/or modify   **
**    it under the terms of the GNU General Public License as published by   **
**    the Free Software Foundation; either version 2 of the License, or      **
**    (at your option) any later version.                                    **
**                                                                           **
**    This program is distributed in the hope that it will be useful,        **
**    but WITHOUT ANY WARRANTY; without even the implied warranty of         **
**    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          **
**    GNU General Public License for more details.                           **
**                                                                           **
**    You should have received a copy of the GNU General Public License      **
**    along with this program; if not, write to the Free Software            **
**    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              **
**                                                                           **
******************************************************************************/
/*
** density.cpp
*/
#include "density.h"

#include <misc.h>


Density::Density(textureBase *p):textureBase(DENSITY,p)
{

	setName("Density");
	setInfo("Density");
	setSubItems(true);
	elementnr=0;
}



textureBase *Density::getFirstElement()
{
#ifdef DEBUG
	printf("Getting first Density-Element (length=%d)\n",elements.length());
#endif
	elementnr=0;
	if (elements.length()==0) return NULL;
	return elements[0];
	
}

textureBase *Density::getNextElement()
{
#ifdef DEBUG
	printf("Getting next Density-Element (length=%d)\n",elements.length());
#endif
	elementnr++;
	if (elementnr>=elements.length()) return NULL;

	return elements[elementnr];

}

bool Density::isEqual(textureBase *tb)
{
textureBase *tb1;
int i;
#ifdef DEBUG
	printf("Comparing Densitys..\n");
#endif

	if (tb==NULL) return false;

	if (tb->getType()!=DENSITY) return false;


	if (textureBase::isEqual(tb)==false) return false;

	tb1=tb->getFirstElement();

	if ( ( (tb1==NULL)&&(elements.length()==0) ) ) return true;

	for (i=0;i<elements.length();i++) {
     		if (tb1==NULL) return false;
		if (tb1->isEqual(elements[i])==false) return false;
		tb1=tb->getNextElement();		
	}

#ifdef DEBUG
	printf("Compared Densitys..found it !\n");
#endif
	return true;




}

bool Density::canAdd(textureBase *tb)
{
	if (tb->getType()==COLOR) return true;
	if (tb->getType()==COLORENTRY) return true;
	if (tb->getType()==TURBULENCEMODIFIER) return true;
	if (tb->getType()==TRANSFORMATIONS) return true;
	return false;
}

void Density::setActive(bool a, textureBase *tb)
{
	if (tb==NULL) {
		textureBase::setActive(a,NULL);
		return;
	}
	tb->setActive(a,NULL);
}

void Density::addElement(textureBase* what,textureBase *where)
{
      	if (what==NULL) return;
	if ( canAdd(what)==false) return;

	what->setParent(this);
	what->setActive(true,NULL);
#ifdef DEBUG
	printf("Adding Density-Element (length=%d)\n",elements.length());
#endif
	elements.append(what);
	sortDensity();
}

void Density::add(textureBase *tb)
{
	if (canAdd(tb)==false) return;
	addElement(tb,NULL);
}


void Density::updateInfo()
{
	char *buffer=(char *)malloc(512);
	
	sprintf(buffer,"Density (%d Elements)",elements.length());
	setInfo(buffer);
	free(buffer);
}

patternmodifier *Density::getMapModifier()
{
	return &modifier;
}



void Density::remove(textureBase *tb)
{
int i;
	for (i=0;i<elements.length();i++) {
		if (tb->isEqual(elements[i])) {
			elements.deleteAt(i);			
			i=elements.length()+1;
		}
	}
	sortDensity();
	updateInfo();
}


Density::~Density()
{
}

void Density::clearDensity()
{
	elements.empty();
	updateInfo();
}

void Density::sortDensity()
{
int a,i,j;
colorEntry *ce;

#ifdef DEBUG
	printf("sorting Density\n");
#endif
	a=elements.length();
	for (i=1;i<a;i++) {
		for (j=0;j<i;j++) {
			if ( ((colorEntry*)elements[j])->getRange()>((colorEntry*)elements[j+1])->getRange() ) {
				//printf("swapped\n");
				ce=(colorEntry*)elements[j+1];
				elements[j+1]=elements[j];
				elements[j]=ce;

			}
		}
	}	
#ifdef DEBUG
	printf("Density sorted\n");
#endif
	updateInfo();
}
int	Density::load(media *m,int l)
{
	colorEntry *ce;
	char	chunk[4];
	bool 	read;
	int	len,pos = m->tell();

	if(!m)	return -1;
	setMedia(m);

#ifdef DEBUG
	printf("loading Density\n");
#endif

	do {
		m->read(chunk,4);
		m->read(&len,4);
		read=false;

		if(strncmp(chunk,"COLE",4) == 0) {
			ce=new colorEntry(this);
			ce->load(m,len);
			elements.append(ce);
			read=true;
		}
		if(strncmp(chunk,"TRNS",4) == 0) {
			Transformations *tr=new Transformations(this);
			tr->load(m,len);
			elements.append(tr);
			read=true;			
		}
		if(strncmp(chunk,"TURB",4) == 0) {
			Turbulence *turb=new Turbulence(this);
			turb->load(m,len);
			elements.append(turb);
			read=true;
		}
		if(strncmp(chunk,"MAPM",4) == 0) {
			modifier.load(m,len);
			read=true;
		}
		if(strncmp(chunk,"BASE",4) == 0) {
			textureBase::load(m,len);
			read=true;
		}
		if (read==false) { m->seek(len,SEEK_CUR); }
	} while (m->tell()< (pos+l) );
	m->seek(pos+l,SEEK_SET); // Man weiss ja nie...

#ifdef DEBUG
	printf("Density loaded\n");
#endif
 	sortDensity();
	updateInfo();
	return 0;
}

int	Density::save(media *m)
{

int i;
	if(!m) return -1;
#ifdef DEBUG
	printf("saving Density\n");
#endif
	setMedia(m);
	
	writeChunk("DENS");
	textureBase::save(m);

	for (i=0;i<elements.length();i++)  {
		elements[i]->save(m);			
	}
	modifier.save(m);

	writeChunkLen();

	#ifdef DEBUG
		printf("Density saved\n");
	#endif*/
	return 0;

}

int Density::exportPOV(FILE *fp,int tab,int tabsize,int a,bool dummy)
{
int i;
	if(!fp)	return -1;

#ifdef DEBUG
	printf("exporting Density (POV)\n");
#endif

	printTab(fp,tab+tabsize);
	fprintf(fp,"density { //%s\n",getName() );	
	modifier.exportPOV(fp,tab+2*tabsize,tabsize,a,false);
	printTab(fp,tab+2*tabsize);
	fprintf(fp,"color_map { //%s\n",getName() );	
	for (i=0;i<elements.length();i++)  {
		if ((elements[i]->active()==true)&&(elements[i]->getType()==COLORENTRY)) elements[i]->exportPOV(fp,tab+3*tabsize,tabsize,a,false);			
	}

	printTab(fp,tab+2*tabsize);
	fprintf(fp,"}\n" );	
	for (i=0;i<elements.length();i++)  {
		if ((elements[i]->active()==true)&&(elements[i]->getType()==TURBULENCEMODIFIER)) elements[i]->exportPOV(fp,tab+3*tabsize,tabsize,a,false);	
	}
	for (i=0;i<elements.length();i++)  {
		if ((elements[i]->active()==true)&&(elements[i]->getType()==TRANSFORMATIONS)) elements[i]->exportPOV(fp,tab+3*tabsize,tabsize,a,false);
	}
	printTab(fp,tab+tabsize);
	fprintf(fp,"}\n" );	
	#ifdef DEBUG
		printf("Density exported (POV)\n");
	#endif
	return 0;
}

